/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.wadl.generators.resourcedoc;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.server.wadl.generators.resourcedoc.ResourceDocAccessor;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ClassDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.MethodDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ParamDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.RepresentationDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResourceDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResponseDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.WadlParamType;
import com.sun.jersey.server.wadl.generators.resourcedoc.xhtml.Elements;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.ParamStyle;
import com.sun.research.ws.wadl.RepresentationType;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlGeneratorResourceDocSupport
implements WadlGenerator {
    private static final Logger LOG = Logger.getLogger(WadlGeneratorResourceDocSupport.class.getName());
    public static final String RESOURCE_DOC_FILE = "resourcedoc.xml";
    private WadlGenerator _delegate;
    private File _resourceDocFile;
    private ResourceDocAccessor _resourceDoc;

    public WadlGeneratorResourceDocSupport() {
    }

    public WadlGeneratorResourceDocSupport(WadlGenerator wadlGenerator, ResourceDocType resourceDoc) {
        this._delegate = wadlGenerator;
        this._resourceDoc = new ResourceDocAccessor(resourceDoc);
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    public void setResourceDocFile(File resourceDocFile) {
        this._resourceDocFile = resourceDocFile;
    }

    @Override
    public void init() throws Exception {
        this._delegate.init();
        ResourceDocType resourceDoc = this.loadFile(this._resourceDocFile, ResourceDocType.class);
        this._resourceDoc = new ResourceDocAccessor(resourceDoc);
    }

    private <T> T loadFile(File fileToLoad, Class<T> targetClass) {
        if (fileToLoad != null) {
            try {
                JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{targetClass});
                Unmarshaller m = c.createUnmarshaller();
                return targetClass.cast(m.unmarshal(fileToLoad));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not unmarshal file " + fileToLoad, e);
            }
        }
        return null;
    }

    @Override
    public String getRequiredJaxbContextPath() {
        String name = Elements.class.getName();
        name = name.substring(0, name.lastIndexOf(46));
        return this._delegate.getRequiredJaxbContextPath() == null ? name : this._delegate.getRequiredJaxbContextPath() + ":" + name;
    }

    @Override
    public Application createApplication() {
        return this._delegate.createApplication();
    }

    @Override
    public Resource createResource(AbstractResource r, String path) {
        Resource result = this._delegate.createResource(r, path);
        ClassDocType classDoc = this._resourceDoc.getClassDoc(r.getResourceClass());
        if (classDoc != null && !this.isEmpty(classDoc.getCommentText())) {
            Doc doc = new Doc();
            doc.getContent().add(classDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Method createMethod(AbstractResource r, AbstractResourceMethod m) {
        Method result = this._delegate.createMethod(r, m);
        MethodDocType methodDoc = this._resourceDoc.getMethodDoc(r.getResourceClass(), m.getMethod());
        if (methodDoc != null && !this.isEmpty(methodDoc.getCommentText())) {
            Doc doc = new Doc();
            doc.getContent().add(methodDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public RepresentationType createRequestRepresentation(AbstractResource r, AbstractResourceMethod m, MediaType mediaType) {
        RepresentationType result = this._delegate.createRequestRepresentation(r, m, mediaType);
        RepresentationDocType requestRepresentation = this._resourceDoc.getRequestRepresentation(r.getResourceClass(), m.getMethod(), result.getMediaType());
        if (requestRepresentation != null) {
            result.setElement(requestRepresentation.getElement());
            this.addDocForExample(result.getDoc(), requestRepresentation.getExample());
        }
        return result;
    }

    @Override
    public Request createRequest(AbstractResource r, AbstractResourceMethod m) {
        return this._delegate.createRequest(r, m);
    }

    @Override
    public Response createResponse(AbstractResource r, AbstractResourceMethod m) {
        ResponseDocType responseDoc = this._resourceDoc.getResponse(r.getResourceClass(), m.getMethod());
        if (responseDoc != null && responseDoc.hasRepresentations()) {
            Response response = new Response();
            for (RepresentationDocType representationDoc : responseDoc.getRepresentations()) {
                RepresentationType wadlRepresentation = new RepresentationType();
                wadlRepresentation.setElement(representationDoc.getElement());
                wadlRepresentation.getStatus().add(representationDoc.getStatus());
                wadlRepresentation.setMediaType(representationDoc.getMediaType());
                this.addDocForExample(wadlRepresentation.getDoc(), representationDoc.getExample());
                this.addDoc(wadlRepresentation.getDoc(), representationDoc.getDoc());
                JAXBElement element = new JAXBElement(new QName("http://research.sun.com/wadl/2006/10", "representation"), RepresentationType.class, (Object)wadlRepresentation);
                response.getRepresentationOrFault().add((JAXBElement<RepresentationType>)element);
            }
            return response;
        }
        Response response = this._delegate.createResponse(r, m);
        if (responseDoc != null && !responseDoc.getWadlParams().isEmpty()) {
            for (WadlParamType wadlParamType : responseDoc.getWadlParams()) {
                Param param = new Param();
                param.setName(wadlParamType.getName());
                param.setStyle(ParamStyle.fromValue(wadlParamType.getStyle()));
                param.setType(wadlParamType.getType());
                this.addDoc(param.getDoc(), wadlParamType.getDoc());
                response.getParam().add(param);
            }
        }
        if (responseDoc != null && !this.isEmpty(responseDoc.getReturnDoc())) {
            this.addDoc(response.getDoc(), responseDoc.getReturnDoc());
        }
        return response;
    }

    private void addDocForExample(List<Doc> docs, String example) {
        if (!this.isEmpty(example)) {
            Doc doc = new Doc();
            Elements pElement = Elements.el("p").add(Elements.val("h6", "Example")).add(new Object[]{Elements.el("pre").add(Elements.val("code", example))});
            doc.getContent().add((Object)pElement);
            docs.add(doc);
        }
    }

    private void addDoc(List<Doc> docs, String text) {
        if (!this.isEmpty(text)) {
            Doc doc = new Doc();
            doc.getContent().add(text);
            docs.add(doc);
        }
    }

    @Override
    public Param createParam(AbstractResource r, AbstractMethod m, Parameter p) {
        Param result = this._delegate.createParam(r, m, p);
        ParamDocType paramDoc = this._resourceDoc.getParamDoc(r.getResourceClass(), m.getMethod(), p);
        if (paramDoc != null && !this.isEmpty(paramDoc.getCommentText())) {
            Doc doc = new Doc();
            doc.getContent().add(paramDoc.getCommentText());
            result.getDoc().add(doc);
        }
        return result;
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }

    private boolean isEmpty(String text) {
        return text == null || text.length() == 0 || "".equals(text.trim());
    }
}

