/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.uri.rules;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.uri.rules.BaseRule;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubLocatorRule
extends BaseRule {
    private final List<AbstractHttpContextInjectable> is;
    private final Method m;
    private final List<ContainerRequestFilter> requestFilters;
    private final List<ContainerResponseFilter> responseFilters;

    public SubLocatorRule(UriTemplate template, Method m, List<Injectable> is, List<ContainerRequestFilter> requestFilters, List<ContainerResponseFilter> responseFilters) {
        super(template);
        this.m = m;
        this.is = AbstractHttpContextInjectable.transform(is);
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    @Override
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        this.pushMatch(context);
        resource = this.invokeSubLocator(resource, context);
        if (resource instanceof Class) {
            resource = context.getResource((Class)resource);
        }
        context.pushResource(resource);
        Iterator<UriRule> matches = context.getRules(resource.getClass()).match(path, context);
        while (matches.hasNext()) {
            if (!matches.next().accept(path, resource, context)) continue;
            return true;
        }
        return false;
    }

    private Object invokeSubLocator(Object resource, UriRuleContext context) {
        context.pushContainerResponseFilters(this.responseFilters);
        if (!this.requestFilters.isEmpty()) {
            ContainerRequest containerRequest = context.getContainerRequest();
            for (ContainerRequestFilter f : this.requestFilters) {
                containerRequest = f.filter(containerRequest);
                context.setContainerRequest(containerRequest);
            }
        }
        try {
            if (this.is.size() == 0) {
                return this.m.invoke(resource, new Object[0]);
            }
            Object[] params = new Object[this.is.size()];
            int index = 0;
            for (AbstractHttpContextInjectable i : this.is) {
                params[index++] = i.getValue(context);
            }
            return this.m.invoke(resource, params);
        }
        catch (InvocationTargetException e) {
            throw new MappableContainerException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new ContainerException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ContainerException("Exception injecting parameters for sub-locator method: " + this.m, e);
        }
    }
}

