/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.modelapi.annotation;

import com.sun.jersey.api.model.AbstractField;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceConstructor;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSetterMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.api.model.Parameterized;
import com.sun.jersey.api.model.PathValue;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.impl.ImplMessages;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionModeller {
    private static final Logger LOGGER = Logger.getLogger(IntrospectionModeller.class.getName());
    private static final Map<Class, ParamAnnotationHelper> ANOT_HELPER_MAP = IntrospectionModeller.createParamAnotHelperMap();

    public static final AbstractResource createResource(Class<?> resourceClass) {
        Class annotatedResourceClass = IntrospectionModeller.getAnnotatedResourceClass(resourceClass);
        Path rPathAnnotation = annotatedResourceClass.getAnnotation(Path.class);
        boolean isRootResourceClass = null != rPathAnnotation;
        boolean isEncodedAnotOnClass = null != annotatedResourceClass.getAnnotation(Encoded.class);
        AbstractResource resource = isRootResourceClass ? new AbstractResource(resourceClass, new PathValue(rPathAnnotation.value())) : new AbstractResource(resourceClass);
        IntrospectionModeller.workOutConstructorsList(resource, resourceClass.getConstructors(), isEncodedAnotOnClass);
        IntrospectionModeller.workOutFieldsList(resource, isEncodedAnotOnClass);
        MethodList methodList = new MethodList(resourceClass);
        IntrospectionModeller.workOutSetterMethodsList(resource, methodList, isEncodedAnotOnClass);
        Consumes classScopeConsumesAnnotation = annotatedResourceClass.getAnnotation(Consumes.class);
        Produces classScopeProducesAnnotation = annotatedResourceClass.getAnnotation(Produces.class);
        IntrospectionModeller.workOutResourceMethodsList(resource, methodList, isEncodedAnotOnClass, classScopeConsumesAnnotation, classScopeProducesAnnotation);
        IntrospectionModeller.workOutSubResourceMethodsList(resource, methodList, isEncodedAnotOnClass, classScopeConsumesAnnotation, classScopeProducesAnnotation);
        IntrospectionModeller.workOutSubResourceLocatorsList(resource, methodList, isEncodedAnotOnClass);
        IntrospectionModeller.workOutPostConstructPreDestroy(resource, methodList);
        IntrospectionModeller.logNonPublicMethods(resourceClass);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(ImplMessages.NEW_AR_CREATED_BY_INTROSPECTION_MODELER(resource.toString()));
        }
        return resource;
    }

    private static final Class getAnnotatedResourceClass(Class rc) {
        if (rc.isAnnotationPresent(Path.class)) {
            return rc;
        }
        for (Class<?> i : rc.getInterfaces()) {
            if (!i.isAnnotationPresent(Path.class)) continue;
            return i;
        }
        return rc;
    }

    private static final void addConsumes(AnnotatedMethod am, AbstractResourceMethod resourceMethod, Consumes consumeMimeAnnotation) {
        if (am.isAnnotationPresent(Consumes.class)) {
            consumeMimeAnnotation = am.getAnnotation(Consumes.class);
        }
        resourceMethod.getSupportedInputTypes().addAll(MediaTypes.createMediaTypes(consumeMimeAnnotation));
    }

    private static final void addProduces(AnnotatedMethod am, AbstractResourceMethod resourceMethod, Produces produceMimeAnnotation) {
        if (am.isAnnotationPresent(Produces.class)) {
            produceMimeAnnotation = am.getAnnotation(Produces.class);
        }
        resourceMethod.setAreInputTypesDeclared(produceMimeAnnotation != null);
        resourceMethod.getSupportedOutputTypes().addAll(MediaTypes.createMediaTypes(produceMimeAnnotation));
    }

    private static final void workOutConstructorsList(AbstractResource resource, Constructor[] ctorArray, boolean isEncoded) {
        if (null != ctorArray) {
            for (Constructor ctor : ctorArray) {
                AbstractResourceConstructor aCtor = new AbstractResourceConstructor(ctor);
                IntrospectionModeller.processParameters((Parameterized)aCtor, ctor, isEncoded);
                resource.getConstructors().add(aCtor);
            }
        }
    }

    private static final void workOutFieldsList(AbstractResource resource, boolean isEncoded) {
        Class<?> c = resource.getResourceClass();
        if (c.isInterface()) {
            return;
        }
        while (c != Object.class) {
            for (Field f : c.getDeclaredFields()) {
                AbstractField af = new AbstractField(f);
                Parameter p = IntrospectionModeller.createParameter(f.toString(), 1, isEncoded, f.getType(), f.getGenericType(), f.getAnnotations());
                if (null == p) continue;
                af.getParameters().add(p);
                resource.getFields().add(af);
            }
            c = c.getSuperclass();
        }
    }

    private static void workOutPostConstructPreDestroy(AbstractResource resource, MethodList methodList) {
        Class postConstruct = ReflectionHelper.classForName("javax.annotation.PostConstruct");
        if (postConstruct == null) {
            return;
        }
        Class preDestroy = ReflectionHelper.classForName("javax.annotation.PreDestroy");
        for (AnnotatedMethod m : methodList.hasAnnotation(postConstruct).hasNumParams(0).hasReturnType(Void.TYPE)) {
            resource.getPostConstructMethods().add(m.getMethod());
        }
        for (AnnotatedMethod m : methodList.hasAnnotation(preDestroy).hasNumParams(0).hasReturnType(Void.TYPE)) {
            resource.getPreDestroyMethods().add(m.getMethod());
        }
    }

    private static final void workOutSetterMethodsList(AbstractResource resource, MethodList methodList, boolean isEncoded) {
        for (AnnotatedMethod m : methodList.hasNotMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class).hasNumParams(1).hasReturnType(Void.TYPE).nameStartsWith("set")) {
            AbstractSetterMethod asm = new AbstractSetterMethod(resource, m.getMethod(), m.getAnnotations());
            Parameter p = IntrospectionModeller.createParameter(m.toString(), 1, isEncoded, m.getParameterTypes()[0], m.getGenericParameterTypes()[0], m.getAnnotations());
            if (null == p) continue;
            asm.getParameters().add(p);
            resource.getSetterMethods().add(asm);
        }
    }

    private static final void workOutResourceMethodsList(AbstractResource resource, MethodList methodList, boolean isEncoded, Consumes classScopeConsumesAnnotation, Produces classScopeProducesAnnotation) {
        for (AnnotatedMethod m : methodList.hasMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class)) {
            AbstractResourceMethod resourceMethod = new AbstractResourceMethod(resource, m.getMethod(), m.getMetaMethodAnnotations(HttpMethod.class).get(0).value(), m.getAnnotations());
            IntrospectionModeller.addConsumes(m, resourceMethod, classScopeConsumesAnnotation);
            IntrospectionModeller.addProduces(m, resourceMethod, classScopeProducesAnnotation);
            IntrospectionModeller.processParameters((Parameterized)resourceMethod, m, isEncoded);
            resource.getResourceMethods().add(resourceMethod);
        }
    }

    private static final void workOutSubResourceMethodsList(AbstractResource resource, MethodList methodList, boolean isEncoded, Consumes classScopeConsumesAnnotation, Produces classScopeProducesAnnotation) {
        for (AnnotatedMethod m : methodList.hasMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            Path mPathAnnotation = m.getAnnotation(Path.class);
            AbstractSubResourceMethod subResourceMethod = new AbstractSubResourceMethod(resource, m.getMethod(), new PathValue(mPathAnnotation.value()), m.getMetaMethodAnnotations(HttpMethod.class).get(0).value(), m.getAnnotations());
            IntrospectionModeller.addConsumes(m, subResourceMethod, classScopeConsumesAnnotation);
            IntrospectionModeller.addProduces(m, subResourceMethod, classScopeProducesAnnotation);
            IntrospectionModeller.processParameters((Parameterized)subResourceMethod, m, isEncoded);
            resource.getSubResourceMethods().add(subResourceMethod);
        }
    }

    private static final void workOutSubResourceLocatorsList(AbstractResource resource, MethodList methodList, boolean isEncoded) {
        for (AnnotatedMethod m : methodList.hasNotMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            Path mPathAnnotation = m.getAnnotation(Path.class);
            AbstractSubResourceLocator subResourceLocator = new AbstractSubResourceLocator(resource, m.getMethod(), new PathValue(mPathAnnotation.value()), m.getAnnotations());
            IntrospectionModeller.processParameters((Parameterized)subResourceLocator, m, isEncoded);
            resource.getSubResourceLocators().add(subResourceLocator);
        }
    }

    private static final void processParameters(Parameterized parametrized, Constructor ctor, boolean isEncoded) {
        IntrospectionModeller.processParameters(ctor.toString(), parametrized, null != ctor.getAnnotation(Encoded.class) || isEncoded, ctor.getParameterTypes(), ctor.getGenericParameterTypes(), ctor.getParameterAnnotations());
    }

    private static final void processParameters(Parameterized parametrized, AnnotatedMethod method, boolean isEncoded) {
        IntrospectionModeller.processParameters(method.toString(), parametrized, null != method.getAnnotation(Encoded.class) || isEncoded, method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations());
    }

    private static final void processParameters(String nameForLogging, Parameterized parametrized, boolean isEncoded, Class[] parameterTypes, Type[] genericParameterTypes, Annotation[][] parameterAnnotations) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameter = IntrospectionModeller.createParameter(nameForLogging, i + 1, isEncoded, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
            if (null == parameter) {
                parametrized.getParameters().removeAll(parametrized.getParameters());
                break;
            }
            parametrized.getParameters().add(parameter);
        }
    }

    private static Map<Class, ParamAnnotationHelper> createParamAnotHelperMap() {
        WeakHashMap<Class, ParamAnnotationHelper<Context>> m = new WeakHashMap<Class, ParamAnnotationHelper<Context>>();
        m.put(Context.class, new ParamAnnotationHelper<Context>(){

            @Override
            public String getValueOf(Context a) {
                return null;
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.CONTEXT;
            }
        });
        m.put(HeaderParam.class, new ParamAnnotationHelper<HeaderParam>(){

            @Override
            public String getValueOf(HeaderParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.HEADER;
            }
        });
        m.put(CookieParam.class, new ParamAnnotationHelper<CookieParam>(){

            @Override
            public String getValueOf(CookieParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.COOKIE;
            }
        });
        m.put(MatrixParam.class, new ParamAnnotationHelper<MatrixParam>(){

            @Override
            public String getValueOf(MatrixParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.MATRIX;
            }
        });
        m.put(QueryParam.class, new ParamAnnotationHelper<QueryParam>(){

            @Override
            public String getValueOf(QueryParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.QUERY;
            }
        });
        m.put(PathParam.class, new ParamAnnotationHelper<PathParam>(){

            @Override
            public String getValueOf(PathParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.PATH;
            }
        });
        return Collections.unmodifiableMap(m);
    }

    private static final Parameter createParameter(String nameForLogging, int order, boolean isEncoded, Class<?> paramClass, Type paramType, Annotation[] annotations) {
        if (null == annotations) {
            return null;
        }
        Annotation paramAnnotation = null;
        Parameter.Source paramSource = null;
        String paramName = null;
        boolean paramEncoded = isEncoded;
        String paramDefault = null;
        for (Annotation annotation : annotations) {
            if (ANOT_HELPER_MAP.containsKey(annotation.annotationType())) {
                ParamAnnotationHelper helper = ANOT_HELPER_MAP.get(annotation.annotationType());
                if (null != paramSource && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(ImplMessages.AMBIGUOUS_PARAMETER(nameForLogging, Integer.toString(order)));
                }
                paramAnnotation = annotation;
                paramSource = helper.getSource();
                paramName = helper.getValueOf(annotation);
                continue;
            }
            if (Encoded.class == annotation.annotationType()) {
                paramEncoded = true;
                continue;
            }
            if (DefaultValue.class == annotation.annotationType()) {
                paramDefault = ((DefaultValue)annotation).value();
                continue;
            }
            paramAnnotation = annotation;
            paramSource = Parameter.Source.UNKNOWN;
            paramName = IntrospectionModeller.getValue(annotation);
        }
        if (paramAnnotation == null) {
            paramSource = Parameter.Source.ENTITY;
        }
        return new Parameter(annotations, paramAnnotation, paramSource, paramName, paramType, paramClass, paramEncoded, paramDefault);
    }

    private static final String getValue(Annotation a) {
        try {
            Method m = a.annotationType().getMethod("value", new Class[0]);
            if (m.getReturnType() != String.class) {
                return null;
            }
            return (String)m.invoke((Object)a, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void logNonPublicMethods(Class resourceClass) {
        assert (null != resourceClass);
        if (!LOGGER.isLoggable(Level.WARNING)) {
            return;
        }
        MethodList declaredMethods = new MethodList(IntrospectionModeller.getDeclaredMethods(resourceClass));
        for (AnnotatedMethod m : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class).isNotPublic()) {
            LOGGER.warning(ImplMessages.NON_PUB_RES_METHOD(m.getMethod().toGenericString()));
        }
        for (AnnotatedMethod m : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class).isNotPublic()) {
            LOGGER.warning(ImplMessages.NON_PUB_SUB_RES_METHOD(m.getMethod().toGenericString()));
        }
        for (AnnotatedMethod m : declaredMethods.hasNotMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class).isNotPublic()) {
            LOGGER.warning(ImplMessages.NON_PUB_SUB_RES_LOC(m.getMethod().toGenericString()));
        }
    }

    private static List<Method> getDeclaredMethods(final Class _c) {
        final ArrayList<Method> ml = new ArrayList<Method>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            Class c;
            {
                this.c = _c;
            }

            @Override
            public Object run() {
                while (this.c != Object.class && this.c != null) {
                    for (Method m : this.c.getDeclaredMethods()) {
                        ml.add(m);
                    }
                    this.c = this.c.getSuperclass();
                }
                return null;
            }
        });
        return ml;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParamAnnotationHelper<T extends Annotation> {
        public String getValueOf(T var1);

        public Parameter.Source getSource();
    }
}

