/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.header;

import com.sun.jersey.core.header.HttpDateFormat;
import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDisposition {
    private String type;
    private Map<String, String> parameters;
    private String fileName;
    private Date creationDate;
    private Date modificationDate;
    private Date readDate;
    private int size;

    public ContentDisposition(String header) throws ParseException {
        this(HttpHeaderReader.newInstance(header));
    }

    public ContentDisposition(HttpHeaderReader reader) throws ParseException {
        reader.hasNext();
        this.type = reader.nextToken();
        if (reader.hasNext()) {
            this.parameters = HttpHeaderReader.readParameters(reader);
        }
        this.parameters = this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
        this.createParameters();
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public Date getReadDate() {
        return this.readDate;
    }

    public int getSize() {
        return this.size;
    }

    private void createParameters() throws ParseException {
        this.fileName = this.parameters.get("filename");
        this.creationDate = this.createDate("creation-date");
        this.modificationDate = this.createDate("modification-date");
        this.readDate = this.createDate("read-date");
        this.size = this.createInt("size");
    }

    private Date createDate(String name) throws ParseException {
        String value = this.parameters.get(name);
        if (value == null) {
            return null;
        }
        return HttpDateFormat.getPreferedDateFormat().parse(value);
    }

    private int createInt(String name) throws ParseException {
        String value = this.parameters.get(name);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing size parameter of value, " + value, 0);
        }
    }
}

