/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.wadl;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.impl.BuildId;
import com.sun.jersey.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.impl.wadl.WadlGenerator;
import com.sun.jersey.impl.wadl.WadlGeneratorImpl;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.ParamStyle;
import com.sun.research.ws.wadl.RepresentationType;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WadlBuilder {
    private WadlGenerator _wadlGenerator;

    public WadlBuilder() {
        this(new WadlGeneratorImpl());
    }

    public WadlBuilder(WadlGenerator wadlGenerator) {
        this._wadlGenerator = wadlGenerator;
    }

    public Application generate(Set<AbstractResource> resources) {
        Application wadlApplication = this._wadlGenerator.createApplication();
        Resources wadlResources = this._wadlGenerator.createResources();
        HashSet visitedClasses = new HashSet();
        for (AbstractResource r : resources) {
            Resource wadlResource = this.generateResource(r, null, visitedClasses);
            wadlResources.getResource().add(wadlResource);
        }
        wadlApplication.setResources(wadlResources);
        this.addVersion(wadlApplication);
        return wadlApplication;
    }

    public Application generate(AbstractResource resource) {
        Application wadlApplication = this._wadlGenerator.createApplication();
        Resources wadlResources = this._wadlGenerator.createResources();
        HashSet visitedClasses = new HashSet();
        Resource wadlResource = this.generateResource(resource, null, visitedClasses);
        wadlResources.getResource().add(wadlResource);
        wadlApplication.setResources(wadlResources);
        this.addVersion(wadlApplication);
        return wadlApplication;
    }

    public Application generate(AbstractResource resource, String path) {
        Application wadlApplication = this._wadlGenerator.createApplication();
        Resources wadlResources = this._wadlGenerator.createResources();
        Resource wadlResource = this.generateSubResource(resource, path);
        wadlResources.getResource().add(wadlResource);
        wadlApplication.setResources(wadlResources);
        this.addVersion(wadlApplication);
        return wadlApplication;
    }

    private void addVersion(Application wadlApplication) {
        Doc d = new Doc();
        d.getOtherAttributes().put(new QName("http://jersey.dev.java.net/", "generatedBy", "jersey"), BuildId.getBuildId());
        wadlApplication.getDoc().add(0, d);
    }

    private Method generateMethod(AbstractResource r, Map<String, Param> wadlResourceParams, AbstractResourceMethod m) {
        Response wadlResponse;
        Method wadlMethod = this._wadlGenerator.createMethod(r, m);
        Request wadlRequest = this.generateRequest(r, m, wadlResourceParams);
        if (wadlRequest != null) {
            wadlMethod.setRequest(wadlRequest);
        }
        if ((wadlResponse = this.generateResponse(r, m)) != null) {
            wadlMethod.setResponse(wadlResponse);
        }
        return wadlMethod;
    }

    private Request generateRequest(AbstractResource r, AbstractResourceMethod m, Map<String, Param> wadlResourceParams) {
        if (m.getParameters().size() == 0) {
            return null;
        }
        Request wadlRequest = this._wadlGenerator.createRequest(r, m);
        for (Parameter p : m.getParameters()) {
            if (p.getSource() == Parameter.Source.ENTITY) {
                for (MediaType mediaType : m.getSupportedInputTypes()) {
                    RepresentationType wadlRepresentation = this._wadlGenerator.createRequestRepresentation(r, m, mediaType);
                    wadlRequest.getRepresentation().add(wadlRepresentation);
                }
                continue;
            }
            Param wadlParam = this.generateParam(r, m, p);
            if (wadlParam == null) continue;
            if (wadlParam.getStyle() == ParamStyle.TEMPLATE) {
                wadlResourceParams.put(wadlParam.getName(), wadlParam);
                continue;
            }
            wadlRequest.getParam().add(wadlParam);
        }
        if (wadlRequest.getRepresentation().size() + wadlRequest.getParam().size() == 0) {
            return null;
        }
        return wadlRequest;
    }

    private Param generateParam(AbstractResource r, AbstractMethod m, Parameter p) {
        if (p.getSource() == Parameter.Source.ENTITY || p.getSource() == Parameter.Source.CONTEXT) {
            return null;
        }
        Param wadlParam = this._wadlGenerator.createParam(r, m, p);
        return wadlParam;
    }

    private Resource generateResource(AbstractResource r, String path, Set<Class<?>> visitedClasses) {
        HashMap wadlSubResourceParams;
        Resource wadlSubResource;
        String template;
        Resource wadlResource = this._wadlGenerator.createResource(r, path);
        if (visitedClasses.contains(r.getResourceClass())) {
            return wadlResource;
        }
        visitedClasses.add(r.getResourceClass());
        HashMap<String, Param> wadlResourceParams = new HashMap<String, Param>();
        for (AbstractResourceMethod m : r.getResourceMethods()) {
            Method wadlMethod = this.generateMethod(r, wadlResourceParams, m);
            wadlResource.getMethodOrResource().add(wadlMethod);
        }
        for (Param wadlParam : wadlResourceParams.values()) {
            wadlResource.getParam().add(wadlParam);
        }
        HashMap<String, Resource> wadlSubResources = new HashMap<String, Resource>();
        HashMap wadlSubResourcesParams = new HashMap();
        for (AbstractSubResourceMethod abstractSubResourceMethod : r.getSubResourceMethods()) {
            template = abstractSubResourceMethod.getUriPath().getValue();
            wadlSubResource = (Resource)wadlSubResources.get(template);
            wadlSubResourceParams = (HashMap)wadlSubResourcesParams.get(template);
            if (wadlSubResource == null) {
                wadlSubResource = new Resource();
                wadlSubResource.setPath(template);
                wadlSubResources.put(template, wadlSubResource);
                wadlSubResourceParams = new HashMap();
                wadlSubResourcesParams.put(template, wadlSubResourceParams);
                wadlResource.getMethodOrResource().add(wadlSubResource);
            }
            Method wadlMethod = this.generateMethod(r, wadlSubResourceParams, abstractSubResourceMethod);
            wadlSubResource.getMethodOrResource().add(wadlMethod);
        }
        for (Map.Entry entry : wadlSubResources.entrySet()) {
            template = (String)entry.getKey();
            wadlSubResource = (Resource)entry.getValue();
            wadlSubResourceParams = (Map)wadlSubResourcesParams.get(template);
            for (Param wadlParam : wadlSubResourceParams.values()) {
                wadlSubResource.getParam().add(wadlParam);
            }
        }
        for (AbstractSubResourceLocator abstractSubResourceLocator : r.getSubResourceLocators()) {
            AbstractResource subResource = IntrospectionModeller.createResource(abstractSubResourceLocator.getMethod().getReturnType());
            wadlSubResource = this.generateResource(subResource, abstractSubResourceLocator.getUriPath().getValue(), visitedClasses);
            wadlResource.getMethodOrResource().add(wadlSubResource);
            for (Parameter p : abstractSubResourceLocator.getParameters()) {
                Param wadlParam;
                wadlParam = this.generateParam(r, abstractSubResourceLocator, p);
                if (wadlParam == null || wadlParam.getStyle() != ParamStyle.TEMPLATE) continue;
                wadlSubResource.getParam().add(wadlParam);
            }
        }
        return wadlResource;
    }

    private Resource generateSubResource(AbstractResource r, String path) {
        Resource wadlResource = new Resource();
        if (r.isRootResource()) {
            StringBuilder b = new StringBuilder(r.getUriPath().getValue());
            if (!r.getUriPath().getValue().endsWith("/") && !path.startsWith("/")) {
                b.append("/");
            }
            b.append(path);
            wadlResource.setPath(b.toString());
        }
        HashMap<String, Param> wadlSubResourceParams = new HashMap<String, Param>();
        for (AbstractSubResourceMethod m : r.getSubResourceMethods()) {
            String template = m.getUriPath().getValue();
            if (!template.equals(path)) continue;
            Method wadlMethod = this.generateMethod(r, wadlSubResourceParams, m);
            wadlResource.getMethodOrResource().add(wadlMethod);
        }
        for (Param wadlParam : wadlSubResourceParams.values()) {
            wadlResource.getParam().add(wadlParam);
        }
        return wadlResource;
    }

    private Response generateResponse(AbstractResource r, AbstractResourceMethod m) {
        if (m.getMethod().getReturnType() == Void.TYPE) {
            return null;
        }
        Response wadlResponse = this._wadlGenerator.createResponse(r, m);
        return wadlResponse;
    }
}

