/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import com.sun.jersey.impl.MultivaluedMapImpl;
import com.sun.jersey.impl.provider.entity.AbstractMessageReaderWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded"})
public final class FormMultivaluedMapProvider
extends AbstractMessageReaderWriterProvider<MultivaluedMap<String, String>> {
    private final Type mapType;

    public FormMultivaluedMapProvider() {
        ParameterizedType iface = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.mapType = iface.getActualTypeArguments()[0];
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return type == MultivaluedMap.class && (type == genericType || this.mapType.equals(genericType));
    }

    public MultivaluedMap<String, String> readFrom(Class<MultivaluedMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String encoded = FormMultivaluedMapProvider.readFromAsString(entityStream, mediaType);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        StringTokenizer tokenizer = new StringTokenizer(encoded, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            if (idx < 0) {
                map.add(URLDecoder.decode(token, "UTF-8"), null);
                continue;
            }
            if (idx <= 0) continue;
            map.add(URLDecoder.decode(token.substring(0, idx), "UTF-8"), URLDecoder.decode(token.substring(idx + 1), "UTF-8"));
        }
        return map;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations) {
        return MultivaluedMap.class.isAssignableFrom(type);
    }

    public void writeTo(MultivaluedMap<String, String> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : t.entrySet()) {
            for (String value : (List)e.getValue()) {
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(URLEncoder.encode((String)e.getKey(), "UTF-8"));
                if (value == null) continue;
                sb.append('=');
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
        }
        FormMultivaluedMapProvider.writeToAsString(sb.toString(), entityStream, mediaType);
    }
}

