/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.uri.ExtendedUriInfo;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.MultivaluedMapImpl;
import com.sun.jersey.impl.application.WebApplicationImpl;
import com.sun.jersey.impl.model.ResourceClass;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import com.sun.jersey.spi.uri.rules.UriRules;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebApplicationContext
implements UriRuleContext,
ExtendedUriInfo {
    private final ContainerRequest request;
    private final ContainerResponse response;
    private final WebApplicationImpl app;
    private Map<String, Object> properties;
    private final LinkedList<Object> resources = new LinkedList();
    private final LinkedList<String> paths = new LinkedList();
    private final LinkedList<UriTemplate> templates = new LinkedList();
    private final List<String> capturingGroupValues = new ArrayList<String>();
    private String encodedPath;
    private String decodedPath;
    private List<PathSegment> decodedPathSegments;
    private List<PathSegment> encodedPathSegments;
    private MultivaluedMap<String, String> decodedQueryParameters;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMapImpl encodedTemplateValues;
    private MultivaluedMapImpl decodedTemplateValues;

    public WebApplicationContext(WebApplicationImpl app, ContainerRequest request, ContainerResponse response) {
        this.app = app;
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpRequestContext getRequest() {
        return this.request;
    }

    @Override
    public HttpResponseContext getResponse() {
        return this.response;
    }

    @Override
    public ExtendedUriInfo getUriInfo() {
        return this;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = new HashMap<String, Object>();
        return this.properties;
    }

    @Override
    public Object getResource(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        return rc.provider.getInstance(this.app.getResourceComponentProvider(), this);
    }

    @Override
    public UriRules<UriRule> getRules(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        return rc.getRules();
    }

    @Override
    public List<String> getGroupValues() {
        return this.capturingGroupValues;
    }

    @Override
    public void setTemplateValues(List<String> names) {
        if (this.encodedTemplateValues == null) {
            this.encodedTemplateValues = new MultivaluedMapImpl();
        }
        int i = 0;
        for (String name : names) {
            String value = this.capturingGroupValues.get(i++);
            this.encodedTemplateValues.addFirst(name, value);
            if (this.decodedTemplateValues == null) continue;
            this.decodedTemplateValues.addFirst(UriComponent.decode(name, UriComponent.Type.PATH_SEGMENT), UriComponent.decode(value, UriComponent.Type.PATH));
        }
    }

    @Override
    public void pushResource(Object resource, UriTemplate template) {
        this.resources.addFirst(resource);
        this.templates.addFirst(template);
    }

    @Override
    public void pushRightHandPathLength(int rhpathlen) {
        this.paths.addFirst(this.getEncodedPath().substring(0, this.getEncodedPath().length() - rhpathlen));
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        if (decode) {
            if (this.decodedPath != null) {
                return this.decodedPath;
            }
            this.decodedPath = UriComponent.decode(this.getEncodedPath(), UriComponent.Type.PATH);
            return this.decodedPath;
        }
        return this.getEncodedPath();
    }

    private String getEncodedPath() {
        if (this.encodedPath != null) {
            return this.encodedPath;
        }
        this.encodedPath = this.getRequestUri().getRawPath().substring(this.getBaseUri().getRawPath().length());
        return this.encodedPath;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            if (this.decodedPathSegments != null) {
                return this.decodedPathSegments;
            }
            this.decodedPathSegments = this.extractPathSegments(this.getPath(false), true);
            return this.decodedPathSegments;
        }
        if (this.encodedPathSegments != null) {
            return this.encodedPathSegments;
        }
        this.encodedPathSegments = this.extractPathSegments(this.getPath(false), false);
        return this.encodedPathSegments;
    }

    public String getPathExtension() {
        throw new UnsupportedOperationException();
    }

    public URI getBaseUri() {
        return this.request.getBaseUri();
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    public URI getAbsolutePath() {
        return this.request.getAbsolutePath();
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public URI getRequestUri() {
        return this.request.getRequestUri();
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public UriBuilder getPlatonicRequestUriBuilder() {
        throw new UnsupportedOperationException();
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            if (this.decodedTemplateValues != null) {
                return this.decodedTemplateValues;
            }
            this.decodedTemplateValues = new MultivaluedMapImpl();
            for (Map.Entry e : this.encodedTemplateValues.entrySet()) {
                ArrayList<String> l = new ArrayList<String>();
                for (String v : (List)e.getValue()) {
                    l.add(UriComponent.decode(v, UriComponent.Type.PATH));
                }
                this.decodedTemplateValues.put(UriComponent.decode((String)e.getKey(), UriComponent.Type.PATH_SEGMENT), l);
            }
            return this.decodedTemplateValues;
        }
        return this.encodedTemplateValues;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            if (this.decodedQueryParameters != null) {
                return this.decodedQueryParameters;
            }
            this.decodedQueryParameters = UriComponent.decodeQuery(this.getRequestUri(), true);
            return this.decodedQueryParameters;
        }
        if (this.encodedQueryParameters != null) {
            return this.encodedQueryParameters;
        }
        this.encodedQueryParameters = UriComponent.decodeQuery(this.getRequestUri(), false);
        return this.encodedQueryParameters;
    }

    public List<String> getAncestorResourceURIs() {
        return this.paths;
    }

    public List<Object> getAncestorResources() {
        return this.resources;
    }

    public List<String> getAncestorResourceURIs(boolean decode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<UriTemplate> getAncestorTemplates() {
        return this.templates;
    }

    @Override
    public PathSegment getPathSegment(String name) {
        return this.getPathSegment(name, true);
    }

    @Override
    public PathSegment getPathSegment(String name, boolean decode) {
        boolean index = false;
        int i = -1;
        for (UriTemplate t : this.templates) {
            if (i == -1) {
                i = t.getPathSegmentIndex(name);
                continue;
            }
            i += t.getNumberOfPathSegments();
        }
        return i != -1 ? this.getPathSegments(decode).get(i) : null;
    }

    private List<PathSegment> extractPathSegments(String path, boolean decode) {
        String[] subPaths;
        LinkedList<PathSegment> pathSegments = new LinkedList<PathSegment>();
        if (path == null) {
            return pathSegments;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((subPaths = path.split("/")).length == 0) {
            PathSegmentImpl pathSegment = new PathSegmentImpl("", new MultivaluedMapImpl());
            pathSegments.add(pathSegment);
            return pathSegments;
        }
        for (String subPath : subPaths) {
            if (subPath.length() == 0) continue;
            MultivaluedMapImpl matrixMap = new MultivaluedMapImpl();
            int colon = subPath.indexOf(59);
            if (colon != -1) {
                String matrixParameters = subPath.substring(colon + 1);
                subPath = colon == 0 ? "" : subPath.substring(0, colon);
                this.extractPathParameters(matrixParameters, ";", matrixMap, decode);
            }
            if (decode) {
                subPath = UriComponent.decode(subPath, UriComponent.Type.PATH_SEGMENT);
            }
            PathSegmentImpl pathSegment = new PathSegmentImpl(subPath, matrixMap);
            pathSegments.add(pathSegment);
        }
        return pathSegments;
    }

    private void extractPathParameters(String parameters, String deliminator, MultivaluedMap<String, String> map, boolean decode) {
        for (String s : parameters.split(deliminator)) {
            String key;
            if (s.length() == 0) continue;
            String[] keyVal = s.split("=");
            String string = key = decode ? UriComponent.decode(keyVal[0], UriComponent.Type.PATH_SEGMENT) : keyVal[0];
            if (key.length() == 0) continue;
            String val = keyVal.length == 2 ? (decode ? UriComponent.decode(keyVal[1], UriComponent.Type.PATH_SEGMENT) : keyVal[1]) : "";
            LinkedList<String> list = (LinkedList<String>)map.get((Object)key);
            if (map.get((Object)key) == null) {
                list = new LinkedList<String>();
                map.put((Object)key, list);
            }
            list.add(val);
        }
    }

    public String getConnegExtension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PathSegmentImpl
    implements PathSegment {
        private String path;
        private MultivaluedMap<String, String> matrixParameters;

        PathSegmentImpl(String path, MultivaluedMap<String, String> matrixParameters) {
            this.path = path;
            this.matrixParameters = matrixParameters;
        }

        public String getPath() {
            return this.path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.matrixParameters;
        }
    }
}

