/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.AsyncUniformInterface;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.Filterable;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.RequestBuilder;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.impl.client.ClientRequestImpl;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncWebResource
extends Filterable
implements RequestBuilder<Builder>,
AsyncUniformInterface {
    private final URI u;

    AsyncWebResource(ClientHandler c, URI u) {
        super(c);
        this.u = u;
    }

    public URI getURI() {
        return this.u;
    }

    public UriBuilder getBuilder() {
        return UriBuilder.fromUri((URI)this.u);
    }

    @Override
    public Future<ClientResponse> head() {
        return this.handle(ClientResponse.class, new ClientRequestImpl(this.u, "HEAD"));
    }

    @Override
    public <T> Future<T> options(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "OPTIONS"));
    }

    @Override
    public <T> Future<T> get(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "GET"));
    }

    @Override
    public Future<?> put() {
        return this.voidHandle(new ClientRequestImpl(this.u, "PUT", null));
    }

    @Override
    public Future<?> put(Object requestEntity) {
        return this.voidHandle(new ClientRequestImpl(this.u, "PUT", requestEntity));
    }

    @Override
    public <T> Future<T> put(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "PUT"));
    }

    @Override
    public <T> Future<T> put(Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, "PUT", requestEntity));
    }

    @Override
    public Future<?> post() {
        return this.voidHandle(new ClientRequestImpl(this.u, "POST"));
    }

    @Override
    public Future<?> post(Object requestEntity) {
        return this.voidHandle(new ClientRequestImpl(this.u, "POST", requestEntity));
    }

    @Override
    public <T> Future<T> post(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "POST"));
    }

    @Override
    public <T> Future<T> post(Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, "POST", requestEntity));
    }

    @Override
    public Future<?> delete() {
        return this.voidHandle(new ClientRequestImpl(this.u, "DELETE"));
    }

    @Override
    public Future<?> delete(Object requestEntity) {
        return this.voidHandle(new ClientRequestImpl(this.u, "DELETE", requestEntity));
    }

    @Override
    public <T> Future<T> delete(Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, "DELETE"));
    }

    @Override
    public <T> Future<T> delete(Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, "DELETE", requestEntity));
    }

    @Override
    public Future<?> method(String method) {
        return this.voidHandle(new ClientRequestImpl(this.u, method));
    }

    @Override
    public Future<?> method(String method, Object requestEntity) {
        return this.voidHandle(new ClientRequestImpl(this.u, method, requestEntity));
    }

    @Override
    public <T> Future<T> method(String method, Class<T> c) {
        return this.handle(c, new ClientRequestImpl(this.u, method));
    }

    @Override
    public <T> Future<T> method(String method, Class<T> c, Object requestEntity) {
        return this.handle(c, new ClientRequestImpl(this.u, method, requestEntity));
    }

    @Override
    public Builder entity(Object entity) {
        return (Builder)new Builder(this.u).entity(entity);
    }

    @Override
    public Builder entity(Object entity, MediaType type) {
        return (Builder)new Builder(this.u).entity(entity, type);
    }

    @Override
    public Builder entity(Object entity, String type) {
        return (Builder)new Builder(this.u).entity(entity, type);
    }

    @Override
    public Builder type(MediaType type) {
        return (Builder)new Builder(this.u).type(type);
    }

    @Override
    public Builder type(String type) {
        return (Builder)new Builder(this.u).type(type);
    }

    @Override
    public Builder accept(MediaType ... types) {
        return (Builder)new Builder(this.u).accept(types);
    }

    @Override
    public Builder accept(String ... types) {
        return (Builder)new Builder(this.u).accept(types);
    }

    @Override
    public Builder acceptLanguage(Locale ... locales) {
        return (Builder)new Builder(this.u).acceptLanguage(locales);
    }

    @Override
    public Builder acceptLanguage(String ... locales) {
        return (Builder)new Builder(this.u).acceptLanguage(locales);
    }

    @Override
    public Builder cookie(Cookie cookie) {
        return (Builder)new Builder(this.u).cookie(cookie);
    }

    @Override
    public Builder header(String name, Object value) {
        return (Builder)new Builder(this.u).header(name, value);
    }

    public Builder path(String path) {
        return new Builder(UriBuilder.fromUri((URI)this.u).path(new String[]{path}).build());
    }

    public Builder uri(URI uri) {
        String query;
        UriBuilder b = UriBuilder.fromUri((URI)this.u).encode(false);
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(new String[]{path});
            } else {
                b.path(new String[]{path});
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQueryParams(query);
        }
        return new Builder(b.build());
    }

    private <T> Future<T> handle(final Class<T> c, final ClientRequest ro) {
        FutureTask ft = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                ClientResponse r = AsyncWebResource.this.getHeadHandler().handle(ro);
                if (c == ClientResponse.class) {
                    return c.cast(r);
                }
                if (r.getStatus() < 300) {
                    return r.getEntity(c);
                }
                throw new UniformInterfaceException(r);
            }
        });
        new Thread(ft).start();
        return ft;
    }

    private Future<?> voidHandle(final ClientRequest ro) {
        FutureTask<Object> ft = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ClientResponse r = AsyncWebResource.this.getHeadHandler().handle(ro);
                if (r.getStatus() >= 300) {
                    throw new UniformInterfaceException(r);
                }
                return null;
            }
        });
        new Thread(ft).start();
        return ft;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Builder
    extends PartialRequestBuilder<Builder>
    implements AsyncUniformInterface {
        private final URI u;

        private Builder(URI u) {
            this.u = u;
        }

        private ClientRequest build(String method) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, this.entity, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        private ClientRequest build(String method, Object e) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, e, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        @Override
        public Future<ClientResponse> head() {
            return AsyncWebResource.this.handle(ClientResponse.class, this.build("HEAD"));
        }

        @Override
        public <T> Future<T> options(Class<T> c) {
            return AsyncWebResource.this.handle(c, this.build("OPTIONS"));
        }

        @Override
        public <T> Future<T> get(Class<T> c) {
            return AsyncWebResource.this.handle(c, this.build("GET"));
        }

        @Override
        public Future<?> put() {
            return AsyncWebResource.this.voidHandle(this.build("PUT"));
        }

        @Override
        public Future<?> put(Object requestEntity) {
            return AsyncWebResource.this.voidHandle(this.build("PUT", requestEntity));
        }

        @Override
        public <T> Future<T> put(Class<T> c) {
            return AsyncWebResource.this.handle(c, this.build("PUT"));
        }

        @Override
        public <T> Future<T> put(Class<T> c, Object requestEntity) {
            return AsyncWebResource.this.handle(c, this.build("PUT", requestEntity));
        }

        @Override
        public Future<?> post() {
            return AsyncWebResource.this.voidHandle(this.build("POST"));
        }

        @Override
        public Future<?> post(Object requestEntity) {
            return AsyncWebResource.this.voidHandle(this.build("POST", requestEntity));
        }

        @Override
        public <T> Future<T> post(Class<T> c) {
            return AsyncWebResource.this.handle(c, this.build("POST"));
        }

        @Override
        public <T> Future<T> post(Class<T> c, Object requestEntity) {
            return AsyncWebResource.this.handle(c, this.build("POST", requestEntity));
        }

        @Override
        public Future<?> delete() {
            return AsyncWebResource.this.voidHandle(this.build("DELETE"));
        }

        @Override
        public Future<?> delete(Object requestEntity) {
            return AsyncWebResource.this.voidHandle(this.build("DELETE", requestEntity));
        }

        @Override
        public <T> Future<T> delete(Class<T> c) {
            return AsyncWebResource.this.handle(c, this.build("DELETE"));
        }

        @Override
        public <T> Future<T> delete(Class<T> c, Object requestEntity) {
            return AsyncWebResource.this.handle(c, this.build("DELETE", requestEntity));
        }

        @Override
        public Future<?> method(String method) {
            return AsyncWebResource.this.voidHandle(this.build(method));
        }

        @Override
        public Future<?> method(String method, Object requestEntity) {
            return AsyncWebResource.this.voidHandle(this.build(method, requestEntity));
        }

        @Override
        public <T> Future<T> method(String method, Class<T> c) {
            return AsyncWebResource.this.handle(c, this.build(method));
        }

        @Override
        public <T> Future<T> method(String method, Class<T> c, Object requestEntity) {
            return AsyncWebResource.this.handle(c, this.build(method, requestEntity));
        }
    }
}

