/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.apache.config;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class ApacheHttpClientState {
    private final HttpState state;

    public ApacheHttpClientState() {
        this(new HttpState());
    }

    public ApacheHttpClientState(HttpState state) {
        this.state = state;
    }

    public void setCredentials(String realm, String host, int port, String usernamepassword) {
        AuthScope authScope = new AuthScope(host, port, realm);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(usernamepassword);
        this.getHttpState().setCredentials(authScope, (Credentials)creds);
    }

    public void setCredentials(String realm, String host, int port, String username, String password) {
        AuthScope authScope = new AuthScope(host, port, realm);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        this.getHttpState().setCredentials(authScope, (Credentials)creds);
    }

    public void setCredentials(String realm, String host, int port, String username, String password, String domain, String thisHost) {
        AuthScope authScope = new AuthScope(host, port, realm);
        NTCredentials creds = new NTCredentials(username, password, thisHost, domain);
        this.getHttpState().setCredentials(authScope, (Credentials)creds);
    }

    public void setProxyCredentials(String realm, String host, int port, String usernamepassword) {
        AuthScope authScope = new AuthScope(host, port, realm);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(usernamepassword);
        this.getHttpState().setProxyCredentials(authScope, (Credentials)creds);
    }

    public void setProxyCredentials(String realm, String host, int port, String username, String password) {
        AuthScope authScope = new AuthScope(host, port, realm);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        this.getHttpState().setProxyCredentials(authScope, (Credentials)creds);
    }

    public void setProxyCredentials(String realm, String host, int port, String username, String password, String domain, String thisHost) {
        AuthScope authScope = new AuthScope(host, port, realm);
        NTCredentials creds = new NTCredentials(username, password, thisHost, domain);
        this.getHttpState().setProxyCredentials(authScope, (Credentials)creds);
    }

    public void clearCredentials() {
        this.getHttpState().clearCredentials();
    }

    public void clearProxyCredentials() {
        this.getHttpState().clearProxyCredentials();
    }

    public HttpState getHttpState() {
        return this.state;
    }
}

