/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.apache.config;

import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;

public class DefaultCredentialsProvider
implements CredentialsProvider {
    public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if (scheme == null) {
            return null;
        }
        try {
            JTextField userField = new JTextField();
            JPasswordField passwordField = new JPasswordField();
            if (scheme instanceof NTLMScheme) {
                JTextField domainField = new JTextField();
                Object[] msg = new Object[]{host + ":" + port + " requires Windows authentication", "Domain", domainField, "User Name", userField, "Password", passwordField};
                int response = JOptionPane.showConfirmDialog(null, msg, "Authenticate", 2);
                if (response == 2 || response == -1) {
                    throw new CredentialsNotAvailableException("User cancled windows authentication.");
                }
                return new NTCredentials(userField.getText(), new String(passwordField.getPassword()), host, domainField.getText());
            }
            if (scheme instanceof RFC2617Scheme) {
                Object[] msg = new Object[]{host + ":" + port + " requires authentication with the realm '" + scheme.getRealm() + "'", "User Name", userField, "Password", passwordField};
                int response = JOptionPane.showConfirmDialog(null, msg, "Authenticate", 2);
                if (response == 2 || response == -1) {
                    throw new CredentialsNotAvailableException("User cancled windows authentication.");
                }
                return new UsernamePasswordCredentials(userField.getText(), new String(passwordField.getPassword()));
            }
            throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + scheme.getSchemeName());
        }
        catch (IOException ioe) {
            throw new CredentialsNotAvailableException(ioe.getMessage(), (Throwable)ioe);
        }
    }
}

