/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.istack.maven;

import com.oracle.istack.maven.CommonLogger;
import com.oracle.istack.maven.PropertyResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;

@Mojo(name="import-pom-properties", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.NONE)
public class ImportPropertiesMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> projectRepos;
    private Properties projectProperties = null;

    public void execute() throws MojoExecutionException {
        try {
            MavenProject bomProject;
            this.projectProperties = this.project.getProperties();
            for (bomProject = this.project; bomProject != null && !bomProject.getArtifactId().endsWith("-bom"); bomProject = bomProject.getParent()) {
            }
            if (bomProject == null || !bomProject.getArtifactId().endsWith("-bom")) {
                this.getLog().warn((CharSequence)"No '*-bom' project found in project hierarchy, using this project's pom for import search.");
                bomProject = this.project;
            }
            this.getLog().warn((CharSequence)("Searching project: " + bomProject.getArtifactId()));
            PropertyResolver resolver = new PropertyResolver(new CommonLogger(this.getLog()), this.projectProperties, this.repoSession, this.repoSystem, this.projectRepos);
            resolver.resolveProperties(bomProject);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (XmlPullParserException ex) {
            Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

