/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.osgi.httpservice;

import com.sun.grizzly.osgi.httpservice.OSGiGrizzlyAdapter;
import com.sun.grizzly.osgi.httpservice.OSGiServletAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OSGiCleanMapper {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final TreeSet<String> aliasTree = new TreeSet();
    private static final Map<String, GrizzlyAdapter> registrations = new HashMap<String, GrizzlyAdapter>(16);
    private static final Set<Servlet> registeredServlets = new HashSet<Servlet>(16);
    private Set<String> localAliases = new HashSet<String>(4);
    private HashMap<HttpContext, ArrayList<OSGiServletAdapter>> contextServletAdapterMap = new HashMap(3);

    OSGiCleanMapper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String map(String resource, boolean cutAfterSlash) {
        int i;
        String match = resource;
        do {
            i = 0;
            if (cutAfterSlash) {
                i = match.lastIndexOf(47);
                if (i == -1) {
                    return null;
                }
                match = i == 0 ? "/" : resource.substring(0, i);
            }
            if (!OSGiCleanMapper.containsAlias(match)) continue;
            return match;
        } while (i != 0);
        return null;
    }

    public static boolean containsAlias(String alias) {
        return aliasTree.contains(alias);
    }

    public static boolean contaisServlet(Servlet servlet) {
        return registeredServlets.contains(servlet);
    }

    public static ReentrantLock getLock() {
        return lock;
    }

    static GrizzlyAdapter getAdapter(String alias) {
        return registrations.get(alias);
    }

    public void recycleRegistrationData(String alias) {
        if (OSGiCleanMapper.containsAlias(alias)) {
            aliasTree.remove(alias);
            GrizzlyAdapter adapter = registrations.remove(alias);
            adapter.destroy();
            this.localAliases.remove(alias);
        }
    }

    public void addGrizzlyAdapter(String alias, GrizzlyAdapter adapter) {
        if (!OSGiCleanMapper.containsAlias(alias)) {
            OSGiCleanMapper.registerAliasAdapter(alias, adapter);
            if (adapter instanceof OSGiServletAdapter) {
                registeredServlets.add(((OSGiServletAdapter)adapter).getServletInstance());
            }
            this.localAliases.add(alias);
        }
    }

    public boolean isLocalyRegisteredAlias(String alias) {
        return this.localAliases.contains(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnregister(String alias, boolean callDestroyOnServlet) {
        GrizzlyAdapter adapter;
        if (OSGiCleanMapper.containsAlias(alias) && (adapter = OSGiCleanMapper.getAdapter(alias)) instanceof OSGiServletAdapter) {
            ((OSGiGrizzlyAdapter)((Object)adapter)).getRemovalLock().lock();
            try {
                Servlet servlet = ((OSGiServletAdapter)adapter).getServletInstance();
                registeredServlets.remove(servlet);
                if (callDestroyOnServlet) {
                    servlet.destroy();
                }
            }
            finally {
                ((OSGiGrizzlyAdapter)((Object)adapter)).getRemovalLock().unlock();
            }
        }
        this.recycleRegistrationData(alias);
    }

    public Set<String> getLocalAliases() {
        return Collections.unmodifiableSet(this.localAliases);
    }

    static Set<String> getAllAliases() {
        return aliasTree;
    }

    public boolean containsContext(HttpContext httpContext) {
        return this.contextServletAdapterMap.containsKey(httpContext);
    }

    public List<OSGiServletAdapter> getContext(HttpContext httpContext) {
        return this.contextServletAdapterMap.get(httpContext);
    }

    public void addContext(HttpContext httpContext, ArrayList<OSGiServletAdapter> servletAdapters) {
        this.contextServletAdapterMap.put(httpContext, servletAdapters);
    }

    private static boolean registerAliasAdapter(String alias, GrizzlyAdapter adapter) {
        boolean wasNew = aliasTree.add(alias);
        if (wasNew) {
            registrations.put(alias, adapter);
        }
        return wasNew;
    }
}

