/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.osgi.httpservice;

import com.sun.grizzly.osgi.httpservice.HttpContextImpl;
import com.sun.grizzly.osgi.httpservice.OSGiMainAdapter;
import com.sun.grizzly.osgi.httpservice.util.Logger;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService {
    private final Logger logger;
    private final Bundle bundle;
    final OSGiMainAdapter mainAdapter;

    public HttpServiceImpl(Bundle bundle, Logger logger) {
        this.bundle = bundle;
        this.logger = logger;
        this.mainAdapter = new OSGiMainAdapter(logger, bundle);
    }

    public HttpContext createDefaultHttpContext() {
        return new HttpContextImpl(this.bundle);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.logger.info(new StringBuilder(128).append("Registering servlet: ").append(servlet).append(", under: ").append(alias).append(", with: ").append(initparams).append(" and context: ").append(httpContext).toString());
        this.mainAdapter.registerServletAdapter(alias, servlet, initparams, httpContext, this);
    }

    public void registerResources(String alias, String prefix, HttpContext httpContext) throws NamespaceException {
        this.logger.info(new StringBuilder(128).append("Registering resource: alias: ").append(alias).append(", prefix: ").append(prefix).append(" and context: ").append(httpContext).toString());
        this.mainAdapter.registerResourceAdapter(alias, httpContext, prefix, this);
    }

    public void unregister(String alias) {
        this.logger.info(new StringBuilder(32).append("Unregistering alias: ").append(alias).toString());
        this.mainAdapter.unregisterAlias(alias);
    }
}

