/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.LinuxSpinningWorkaround;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorHandlerRunner
implements Runnable {
    protected static final Logger logger = Logger.getLogger("grizzly");
    private static final int spinRateTreshold = 2000;
    private final SelectorHandler selectorHandler;
    private final Controller controller;
    private boolean isPostponed;
    private SelectionKey key;
    private Set<SelectionKey> readyKeys;
    private NIOContext serverContext;
    private StateHolder<State> controllerStateHolder;
    private StateHolder<State> selectorHandlerStateHolder;

    public SelectorHandlerRunner(Controller controller, SelectorHandler selectorHandler) {
        this.controller = controller;
        this.selectorHandler = selectorHandler;
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean isPostponedInThread;
        block15: {
            block14: {
                block13: {
                    if (!this.isPostponed) {
                        this.serverContext = (NIOContext)this.controller.pollContext();
                        this.serverContext.setSelectorHandler(this.selectorHandler);
                        this.controllerStateHolder = this.controller.getStateHolder();
                        this.selectorHandlerStateHolder = this.selectorHandler.getStateHolder();
                    }
                    ((WorkerThreadImpl)Thread.currentThread()).setPendingIOhandler(this.selectorHandler);
                    isPostponedInThread = false;
                    try {
                        State selectorHandlerState;
                        State controllerState;
                        if (this.isPostponed) {
                            this.isPostponed = false;
                            boolean bl = isPostponedInThread = !this.continueSelect(this.selectorHandler, this.serverContext);
                            if (isPostponedInThread) {
                                Object var5_2 = null;
                                if (isPostponedInThread) return;
                                break block13;
                            }
                        } else {
                            this.selectorHandler.getStateHolder().setState(State.STARTED);
                        }
                        while ((controllerState = this.controllerStateHolder.getState(false)) != State.STOPPED && (selectorHandlerState = this.selectorHandlerStateHolder.getState(false)) != State.STOPPED) {
                            if (controllerState != State.PAUSED && selectorHandlerState != State.PAUSED) {
                                isPostponedInThread = !this.doSelect(this.selectorHandler, this.serverContext);
                                if (!isPostponedInThread) continue;
                                break block14;
                            }
                            this.doSelectorPaused(controllerState, selectorHandlerState);
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (isPostponedInThread) throw throwable;
                        try {
                            this.selectorHandler.shutdown();
                            Object var7_12 = null;
                            this.controller.notifyStopped();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            Object var7_13 = null;
                            this.controller.notifyStopped();
                            throw throwable2;
                        }
                    }
                }
                try {}
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.controller.notifyStopped();
                    throw throwable;
                }
                this.selectorHandler.shutdown();
                Object var7_6 = null;
                this.controller.notifyStopped();
                return;
            }
            Object var5_3 = null;
            if (isPostponedInThread) return;
            try {}
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.controller.notifyStopped();
                throw throwable;
            }
            this.selectorHandler.shutdown();
            Object var7_8 = null;
            this.controller.notifyStopped();
            return;
        }
        Object var5_4 = null;
        if (isPostponedInThread) return;
        try {}
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.controller.notifyStopped();
            throw throwable;
        }
        this.selectorHandler.shutdown();
        Object var7_10 = null;
        this.controller.notifyStopped();
    }

    protected boolean continueSelect(SelectorHandler selectorHandler, NIOContext serverCtx) {
        try {
            if (this.key != null && !this.handleSelectedKey(this.key, selectorHandler, serverCtx)) {
                return false;
            }
            if (!this.handleSelectedKeys(this.readyKeys, selectorHandler, serverCtx)) {
                return false;
            }
            selectorHandler.postSelect(serverCtx);
        }
        catch (Throwable e) {
            this.handleSelectException(e, selectorHandler, null);
        }
        return true;
    }

    protected boolean doSelect(SelectorHandler selectorHandler, NIOContext serverCtx) {
        try {
            long sr;
            boolean isSpinWorkaround;
            if (selectorHandler.getSelectionKeyHandler() == null) {
                this.initSelectionKeyHandler(selectorHandler);
            }
            selectorHandler.preSelect(serverCtx);
            this.readyKeys = selectorHandler.select(serverCtx);
            boolean bl = isSpinWorkaround = Controller.isLinux && selectorHandler instanceof LinuxSpinningWorkaround;
            if (this.readyKeys.size() != 0) {
                if (isSpinWorkaround) {
                    ((LinuxSpinningWorkaround)((Object)selectorHandler)).resetSpinCounter();
                }
                if (!this.handleSelectedKeys(this.readyKeys, selectorHandler, serverCtx)) {
                    return false;
                }
            } else if (isSpinWorkaround && (sr = (long)((LinuxSpinningWorkaround)((Object)selectorHandler)).getSpinRate()) > 2000L) {
                ((LinuxSpinningWorkaround)((Object)selectorHandler)).workaroundSelectorSpin();
            }
            selectorHandler.postSelect(serverCtx);
        }
        catch (Throwable e) {
            this.handleSelectException(e, selectorHandler, null);
        }
        return true;
    }

    private void initSelectionKeyHandler(SelectorHandler selectorHandler) {
        SelectionKeyHandler assgnSelectionKeyHandler;
        block5: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Set DefaultSelectionKeyHandler to SelectorHandler: " + selectorHandler);
            }
            assgnSelectionKeyHandler = null;
            if (selectorHandler.getPreferredSelectionKeyHandler() != null) {
                Class<? extends SelectionKeyHandler> keyHandlerClass = selectorHandler.getPreferredSelectionKeyHandler();
                try {
                    assgnSelectionKeyHandler = keyHandlerClass.newInstance();
                    assgnSelectionKeyHandler.setSelectorHandler(selectorHandler);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, "Exception initializing preffered SelectionKeyHandler '" + keyHandlerClass + "' for the SelectorHandler '" + selectorHandler + "'");
                }
            }
        }
        if (assgnSelectionKeyHandler == null) {
            assgnSelectionKeyHandler = new DefaultSelectionKeyHandler(selectorHandler);
        }
        selectorHandler.setSelectionKeyHandler(assgnSelectionKeyHandler);
    }

    private boolean handleSelectedKeys(Set<SelectionKey> readyKeys, SelectorHandler selectorHandler, NIOContext serverCtx) {
        Iterator<SelectionKey> it = readyKeys.iterator();
        while (it.hasNext()) {
            this.key = it.next();
            it.remove();
            if (this.handleSelectedKey(this.key, selectorHandler, serverCtx)) continue;
            return false;
        }
        return true;
    }

    private boolean handleSelectedKey(SelectionKey key, SelectorHandler selectorHandler, NIOContext serverCtx) {
        boolean isLogLevelFine = logger.isLoggable(Level.FINE);
        try {
            Object attachment = key.attachment();
            if (attachment instanceof SelectedKeyAttachmentLogic && !((SelectedKeyAttachmentLogic)attachment).handleSelectedKey(key)) {
                return true;
            }
            if (!key.isValid()) {
                selectorHandler.addPendingKeyCancel(key);
                return true;
            }
            int readyOps = key.readyOps();
            if ((readyOps & 0x10) != 0) {
                if (this.controller.getReadThreadsCount() > 0 && this.controller.multiReadThreadSelectorHandler.supportsProtocol(selectorHandler.protocol())) {
                    if (isLogLevelFine) {
                        this.dolog("OP_ACCEPT passed to multi readthread handler on ", key);
                    }
                    this.controller.multiReadThreadSelectorHandler.onAcceptInterest(key, serverCtx);
                } else {
                    if (isLogLevelFine) {
                        this.dolog("OP_ACCEPT on ", key);
                    }
                    selectorHandler.onAcceptInterest(key, serverCtx);
                }
                return true;
            }
            if ((readyOps & 8) != 0) {
                if (isLogLevelFine) {
                    this.dolog("OP_CONNECT on ", key);
                }
                selectorHandler.onConnectInterest(key, serverCtx);
                return true;
            }
            boolean delegateToWorker = false;
            Context.OpType opType = null;
            boolean skipOpWrite = false;
            if ((readyOps & 1) != 0) {
                if (isLogLevelFine) {
                    this.dolog("OP_READ on ", key);
                }
                if (delegateToWorker = selectorHandler.onReadInterest(key, serverCtx)) {
                    opType = Context.OpType.OP_READ;
                }
                if (!this.controller.isHandleReadWriteConcurrently()) {
                    skipOpWrite = true;
                }
            }
            if (!skipOpWrite && (readyOps & 4) != 0 && key.isValid()) {
                if (isLogLevelFine) {
                    this.dolog("OP_WRITE on ", key);
                }
                boolean opWriteDelegate = selectorHandler.onWriteInterest(key, serverCtx);
                delegateToWorker |= opWriteDelegate;
                if (opWriteDelegate) {
                    opType = opType == Context.OpType.OP_READ ? Context.OpType.OP_READ_WRITE : Context.OpType.OP_WRITE;
                }
            }
            if (delegateToWorker) {
                if (this.controller.useLeaderFollowerStrategy()) {
                    selectorHandler.getThreadPool().execute(this.postpone());
                    NIOContext context = (NIOContext)this.controller.pollContext();
                    this.controller.configureContext(key, opType, context, selectorHandler);
                    ((WorkerThreadImpl)Thread.currentThread()).reset();
                    context.execute(context.getProtocolChainContextTask(), false);
                    return false;
                }
                NIOContext context = (NIOContext)this.controller.pollContext();
                this.controller.configureContext(key, opType, context, selectorHandler);
                context.execute(context.getProtocolChainContextTask());
            }
        }
        catch (Throwable e) {
            this.handleSelectException(e, selectorHandler, key);
        }
        return true;
    }

    private SelectorHandlerRunner postpone() {
        this.key = null;
        this.isPostponed = true;
        ((WorkerThreadImpl)Thread.currentThread()).setPendingIOhandler(null);
        return this;
    }

    private void dolog(String msg, SelectionKey key) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, msg + key + " attachment: " + key.attachment());
        }
    }

    private void handleSelectException(Throwable e, SelectorHandler selectorHandler, SelectionKey key) {
        block21: {
            StateHolder<State> stateHolder = this.controller.getStateHolder();
            if (e instanceof CancelledKeyException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "The key is cancelled asynchronously!");
                }
            } else if (e instanceof ClosedSelectorException) {
                if (stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                    logger.log(Level.WARNING, "Selector was unexpectedly closed.", e);
                    this.controller.notifyException(e);
                    try {
                        if (Controller.isLinux && selectorHandler instanceof LinuxSpinningWorkaround) {
                            ((LinuxSpinningWorkaround)((Object)selectorHandler)).workaroundSelectorSpin();
                            break block21;
                        }
                        SelectorHandlerRunner.switchToNewSelector(selectorHandler);
                    }
                    catch (Exception ee) {
                        logger.log(Level.SEVERE, "Can not workaround Selector close.", ee);
                    }
                } else {
                    logger.log(Level.FINE, "doSelect Selector closed");
                }
            } else if (e instanceof ClosedChannelException) {
                if (stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                    logger.log(Level.WARNING, "Channel was unexpectedly closed");
                    if (key != null) {
                        selectorHandler.getSelectionKeyHandler().cancel(key);
                    }
                    this.controller.notifyException(e);
                }
            } else if (e instanceof IOException) {
                if (stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                    logger.log(Level.SEVERE, "doSelect IOException", e);
                    this.controller.notifyException(e);
                } else {
                    logger.log(Level.FINE, "doSelect IOException", e);
                }
            } else {
                try {
                    if (key != null) {
                        selectorHandler.getSelectionKeyHandler().cancel(key);
                    }
                    this.controller.notifyException(e);
                    logger.log(Level.SEVERE, "doSelect exception", e);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSelectorPaused(State controllerState, State selectorHandlerState) {
        CountDownLatch latch = new CountDownLatch(1);
        StateHolder.ConditionListener<State> controllerConditionListener = this.registerForNotification(controllerState, this.controller.getStateHolder(), latch);
        StateHolder.ConditionListener<State> selectorHandlerConditionListener = this.registerForNotification(selectorHandlerState, this.selectorHandler.getStateHolder(), latch);
        try {
            try {
                latch.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Object var8_7 = null;
                this.controller.getStateHolder().removeConditionListener(controllerConditionListener);
                this.selectorHandler.getStateHolder().removeConditionListener(selectorHandlerConditionListener);
            }
            Object var8_6 = null;
            this.controller.getStateHolder().removeConditionListener(controllerConditionListener);
            this.selectorHandler.getStateHolder().removeConditionListener(selectorHandlerConditionListener);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.controller.getStateHolder().removeConditionListener(controllerConditionListener);
            this.selectorHandler.getStateHolder().removeConditionListener(selectorHandlerConditionListener);
            throw throwable;
        }
    }

    private StateHolder.ConditionListener<State> registerForNotification(State currentState, StateHolder<State> stateHolder, CountDownLatch latch) {
        if (currentState == State.PAUSED) {
            return stateHolder.notifyWhenStateIsNotEqual(State.PAUSED, latch);
        }
        return stateHolder.notifyWhenStateIsEqual(State.STOPPED, latch);
    }

    protected static void switchToNewSelector(SelectorHandler selectorHandler) throws IOException {
        Selector oldSelector = selectorHandler.getSelector();
        Selector newSelector = Utils.openSelector();
        Set<SelectionKey> keys = oldSelector.keys();
        for (SelectionKey key : keys) {
            try {
                key.channel().register(newSelector, key.interestOps(), key.attachment());
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error switching channel to a new selector", e);
            }
        }
        selectorHandler.setSelector(newSelector);
        try {
            oldSelector.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

