/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.Controller;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectorFactory {
    public static final int DEFAULT_MAX_SELECTORS = 20;
    public static long timeout;
    private static int maxSelectors;
    private static final Stack<Selector> selectors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setMaxSelectors(int size) throws IOException {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            if (size < maxSelectors) {
                SelectorFactory.reduce(size);
            } else if (size > maxSelectors) {
                SelectorFactory.grow(size);
            }
            maxSelectors = size;
        }
    }

    public static final int getMaxSelectors() {
        return maxSelectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Selector getSelector() {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            Selector s = null;
            try {
                if (selectors.size() != 0) {
                    s = selectors.pop();
                }
            }
            catch (EmptyStackException ex) {
                // empty catch block
            }
            try {
                for (int attempts = 0; s == null && attempts < 2; ++attempts) {
                    selectors.wait(timeout);
                    try {
                        if (selectors.size() == 0) continue;
                        s = selectors.pop();
                        continue;
                    }
                    catch (EmptyStackException ex) {
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void returnSelector(Selector s) {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            selectors.push(s);
            if (selectors.size() == 1) {
                selectors.notify();
            }
        }
    }

    private static void grow(int size) throws IOException {
        for (int i = 0; i < size - maxSelectors; ++i) {
            selectors.add(Selector.open());
        }
    }

    private static void reduce(int size) {
        for (int i = 0; i < maxSelectors - size; ++i) {
            try {
                Selector selector = selectors.pop();
                selector.close();
                continue;
            }
            catch (IOException e) {
                Logger logger = Controller.logger();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "SelectorFactory.reduce", e);
            }
        }
    }

    static {
        block2: {
            timeout = 5000L;
            selectors = new Stack();
            try {
                SelectorFactory.setMaxSelectors(20);
            }
            catch (IOException ex) {
                Logger logger = Controller.logger();
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "SelectorFactory initializing Selector pool", ex);
            }
        }
    }
}

