/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLReadFilter
implements ProtocolFilter {
    public static final String HANDSHAKE = "handshake";
    public static final String DATA_DECODED = "dataDecoded";
    public static final String INPUT_BB_REMAINDER = "inputBBRemainder";
    public static final String OUTPUT_BB_REMAINDER = "outputBBRemainder";
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    public static final String EXPIRE_TIME = "expireTime";
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;
    protected int inputBBSize = 20480;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        WorkerThreadImpl workerThread;
        boolean result = true;
        int count = 0;
        boolean isCopied = false;
        Throwable exception = null;
        SelectionKey key = ctx.getSelectionKey();
        try {
            workerThread = (WorkerThreadImpl)Thread.currentThread();
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        SSLEngine sslEngine = this.newSSLEngine(key);
        workerThread.setSSLEngine(sslEngine);
        key.attach(sslEngine);
        boolean hasHandshake = Boolean.TRUE.equals(sslEngine.getSession().getValue(HANDSHAKE));
        this.restoreSecuredBufferRemainders(sslEngine);
        try {
            this.allocateBuffers();
            isCopied = SSLReadFilter.copyByteBufferToInputBB(sslEngine, workerThread.getByteBuffer(), workerThread.getInputBB());
            if (hasHandshake) {
                count = SSLReadFilter.doRead(key);
            } else if (SSLReadFilter.doHandshake(key, SSLUtils.getReadTimeout())) {
                hasHandshake = true;
                sslEngine.getSession().putValue(HANDSHAKE, Boolean.TRUE);
            } else {
                count = -1;
            }
        }
        catch (IOException ex) {
            exception = ex;
            this.log("SSLReadFilter.execute", ex);
        }
        catch (Throwable ex) {
            exception = ex;
            this.log("SSLReadFilter.execute", ex);
        }
        finally {
            if (exception != null || count == -1) {
                if (isCopied) {
                    workerThread.getInputBB().clear();
                }
                ctx.setAttribute("throwable", exception);
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                result = false;
            }
        }
        return result;
    }

    public boolean postExecute(Context ctx) throws IOException {
        if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.CANCEL) {
            ctx.getSelectorHandler().getSelectionKeyHandler().cancel(ctx.getSelectionKey());
        } else if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.REGISTER) {
            SSLEngine sslEngine = (SSLEngine)ctx.getSelectionKey().attachment();
            this.saveSecuredBufferRemainders(sslEngine);
            ctx.getSelectorHandler().register(ctx.getSelectionKey(), 1);
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        }
        return true;
    }

    protected void allocateBuffers() {
        ByteBuffer newBB;
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        int expectedSize = workerThread.getSSLEngine().getSession().getPacketBufferSize();
        if (this.inputBBSize < expectedSize) {
            this.inputBBSize = expectedSize;
        }
        if (inputBB != null && inputBB.capacity() < this.inputBBSize) {
            newBB = ByteBuffer.allocate(this.inputBBSize);
            inputBB.flip();
            newBB.put(inputBB);
            inputBB = newBB;
        } else if (inputBB == null) {
            inputBB = ByteBuffer.allocate(this.inputBBSize);
        }
        if (outputBB == null) {
            outputBB = ByteBuffer.allocate(this.inputBBSize);
        }
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(this.inputBBSize * 2);
        }
        if ((expectedSize = workerThread.getSSLEngine().getSession().getApplicationBufferSize()) > byteBuffer.capacity()) {
            newBB = ByteBuffer.allocate(expectedSize);
            byteBuffer.flip();
            newBB.put(byteBuffer);
            byteBuffer = newBB;
        }
        workerThread.setInputBB(inputBB);
        workerThread.setOutputBB(outputBB);
        workerThread.setByteBuffer(byteBuffer);
        outputBB.position(0);
        outputBB.limit(0);
    }

    private static boolean doHandshake(SelectionKey key, int timeout) throws IOException {
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        boolean OK = true;
        try {
            byteBuffer = SSLUtils.doHandshake((SocketChannel)key.channel(), byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, timeout);
            if (SSLReadFilter.doRead(key) == -1) {
                throw new EOFException();
            }
        }
        catch (EOFException ex) {
            Logger logger = Controller.logger();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "doHandshake", ex);
            }
            OK = false;
        }
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doRead(SelectionKey key) {
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        int count = -1;
        try {
            count = ((SocketChannel)key.channel()).read(inputBB);
            if (count != -1) {
                byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                workerThread.setInputBB(inputBB);
                workerThread.setOutputBB(outputBB);
                workerThread.setByteBuffer(byteBuffer);
            }
            int n = count;
            return n;
        }
        catch (IOException ex) {
            int n = -1;
            return n;
        }
        finally {
            if (count == -1) {
                try {
                    sslEngine.closeInbound();
                }
                catch (SSLException ex) {}
            }
        }
    }

    public static Object[] doPeerCertificateChain(SelectionKey key, boolean needClientAuth) throws IOException {
        Logger logger = Controller.logger();
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer inputBB = workerThread.getInputBB();
        ByteBuffer outputBB = workerThread.getOutputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        return SSLUtils.doPeerCertificateChain((SocketChannel)key.channel(), byteBuffer, inputBB, outputBB, sslEngine, needClientAuth, 0);
    }

    protected SSLEngine newSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        if (this.enabledCipherSuites != null) {
            if (!this.isCipherConfigured) {
                this.enabledCipherSuites = SSLReadFilter.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                this.isCipherConfigured = true;
            }
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            if (!this.isProtocolConfigured) {
                this.enabledProtocols = SSLReadFilter.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                this.isProtocolConfigured = true;
            }
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        return sslEngine;
    }

    protected SSLEngine newSSLEngine(SelectionKey key) {
        SSLEngine sslEngine = null;
        sslEngine = key.attachment() == null ? this.newSSLEngine() : (key.attachment() instanceof SSLEngine ? (SSLEngine)key.attachment() : this.newSSLEngine());
        sslEngine.setWantClientAuth(this.wantClientAuth);
        sslEngine.getSession().removeValue(EXPIRE_TIME);
        sslEngine.setNeedClientAuth(this.needClientAuth);
        return sslEngine;
    }

    public void configure(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
        this.wantClientAuth = sslConfig.isWantClientAuth();
        this.needClientAuth = sslConfig.isNeedClientAuth();
        this.clientMode = sslConfig.isClientMode();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    private static final String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    private static boolean copyByteBufferToInputBB(SSLEngine sslEngine, ByteBuffer byteBuffer, ByteBuffer inputBB) {
        if (byteBuffer.position() > 0) {
            Boolean isDataDecoded = (Boolean)sslEngine.getSession().getValue(DATA_DECODED);
            if (!Boolean.TRUE.equals(isDataDecoded)) {
                byteBuffer.flip();
                inputBB.put(byteBuffer);
                byteBuffer.clear();
                return true;
            }
            if (isDataDecoded != null) {
                sslEngine.getSession().removeValue(DATA_DECODED);
            }
        }
        return false;
    }

    private void restoreSecuredBufferRemainders(SSLEngine sslEngine) {
        ByteBuffer outputBBRemainder;
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer inputBBRemainder = (ByteBuffer)sslEngine.getSession().getValue(INPUT_BB_REMAINDER);
        if (inputBBRemainder != null) {
            sslEngine.getSession().removeValue(INPUT_BB_REMAINDER);
            workerThread.setInputBB(inputBBRemainder);
        }
        if ((outputBBRemainder = (ByteBuffer)sslEngine.getSession().getValue(OUTPUT_BB_REMAINDER)) != null) {
            sslEngine.getSession().removeValue(OUTPUT_BB_REMAINDER);
            workerThread.setOutputBB(outputBBRemainder);
        }
    }

    private void saveSecuredBufferRemainders(SSLEngine sslEngine) {
        ByteBuffer outputBB;
        WorkerThreadImpl workerThread = (WorkerThreadImpl)Thread.currentThread();
        ByteBuffer inputBB = workerThread.getInputBB();
        if (inputBB != null && inputBB.hasRemaining()) {
            sslEngine.getSession().putValue(INPUT_BB_REMAINDER, inputBB);
            workerThread.setInputBB(null);
        }
        if ((outputBB = workerThread.getOutputBB()) != null && outputBB.hasRemaining()) {
            sslEngine.getSession().putValue(OUTPUT_BB_REMAINDER, outputBB);
            workerThread.setOutputBB(null);
        }
    }

    protected void log(String msg, Throwable t) {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, "SSLReadFilter,execute()", t);
        }
    }
}

