/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.connectioncache.impl.transport;

import com.sun.grizzly.connectioncache.impl.transport.ConnectionCacheBlockingBase;
import com.sun.grizzly.connectioncache.spi.concurrent.ConcurrentQueue;
import com.sun.grizzly.connectioncache.spi.transport.InboundConnectionCache;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InboundConnectionCacheBlockingImpl<C extends Closeable>
extends ConnectionCacheBlockingBase<C>
implements InboundConnectionCache<C> {
    private final Map<C, ConnectionState<C>> connectionMap = new HashMap<C, ConnectionState<C>>();

    @Override
    protected String thisClassName() {
        return "InboundConnectionCacheBlockingImpl";
    }

    public InboundConnectionCacheBlockingImpl(String cacheType, int highWaterMark, int numberToReclaim, Logger logger) {
        super(cacheType, highWaterMark, numberToReclaim, logger);
        if (this.debug()) {
            this.dprint(".constructor completed: " + this.getCacheType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void requestReceived(C conn) {
        if (this.debug()) {
            this.dprint("->requestReceived: connection " + conn);
        }
        try {
            int count;
            ConcurrentQueue.Handle reclaimHandle;
            ConnectionState<C> cs = this.getConnectionState(conn);
            int totalConnections = this.totalBusy + this.totalIdle;
            if (totalConnections > this.highWaterMark()) {
                this.reclaim();
            }
            if ((reclaimHandle = cs.reclaimableHandle) != null) {
                if (this.debug()) {
                    this.dprint(".requestReceived: " + conn + " removed from reclaimableQueue");
                }
                reclaimHandle.remove();
            }
            if ((count = cs.busyCount++) == 0) {
                if (this.debug()) {
                    this.dprint(".requestReceived: " + conn + " transition from idle to busy");
                }
                --this.totalIdle;
                ++this.totalBusy;
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-requestReceived: connection " + conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void requestProcessed(C conn, int numResponsesExpected) {
        if (this.debug()) {
            this.dprint("->requestProcessed: connection " + conn + " expecting " + numResponsesExpected + " responses");
        }
        try {
            ConnectionState<C> cs = this.connectionMap.get(conn);
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".release: connection " + conn + " was closed");
                }
                return;
            }
            cs.expectedResponseCount += numResponsesExpected;
            int numResp = cs.expectedResponseCount;
            int numBusy = --cs.busyCount;
            if (this.debug()) {
                this.dprint(".release: " + numResp + " responses expected");
                this.dprint(".release: " + numBusy + " busy count for connection");
            }
            if (numBusy == 0) {
                --this.totalBusy;
                ++this.totalIdle;
                if (numResp == 0) {
                    if (this.debug()) {
                        this.dprint(".release: queuing reclaimable connection " + conn);
                    }
                    if (this.totalBusy + this.totalIdle > this.highWaterMark()) {
                        this.close(conn);
                    } else {
                        cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                    }
                }
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-requestProcessed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void responseSent(C conn) {
        if (this.debug()) {
            this.dprint("->responseSent: " + conn);
        }
        try {
            ConnectionState<C> cs = this.connectionMap.get(conn);
            int waitCount = --cs.expectedResponseCount;
            if (waitCount == 0) {
                if (this.debug()) {
                    this.dprint(".responseSent: " + conn + " is now reclaimable");
                }
                if (this.totalBusy + this.totalIdle > this.highWaterMark()) {
                    if (this.debug()) {
                        this.dprint(".responseSent: " + conn + " closing connection");
                    }
                    this.close(conn);
                } else {
                    cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                    if (this.debug()) {
                        this.dprint(".responseSent: " + conn + " is now reclaimable");
                    }
                }
            } else if (this.debug()) {
                this.dprint(".responseSent: " + conn + " waitCount=" + waitCount);
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-responseSent: " + conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(C conn) {
        if (this.debug()) {
            this.dprint("->close: " + conn);
        }
        try {
            ConnectionState<C> cs = this.connectionMap.remove(conn);
            if (cs != null) {
                int count = cs.busyCount;
                if (this.debug()) {
                    this.dprint(".close: " + conn + " count = " + count);
                }
                if (count == 0) {
                    --this.totalIdle;
                } else {
                    --this.totalBusy;
                }
                ConcurrentQueue.Handle rh = cs.reclaimableHandle;
                if (rh != null) {
                    if (this.debug()) {
                        this.dprint(".close: " + conn + " connection was reclaimable");
                    }
                    rh.remove();
                }
                try {
                    conn.close();
                }
                catch (IOException exc) {
                    if (this.debug()) {
                        this.dprint(".close: " + conn + " close threw " + exc);
                    }
                }
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-close: " + conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionState<C> getConnectionState(C conn) {
        if (this.debug()) {
            this.dprint("->getConnectionState: " + conn);
        }
        try {
            ConnectionState<C> result = this.connectionMap.get(conn);
            if (result == null) {
                if (this.debug()) {
                    this.dprint(".getConnectionState: " + conn + " creating new ConnectionState instance");
                }
                result = new ConnectionState<C>(conn);
                this.connectionMap.put(conn, result);
                ++this.totalIdle;
            }
            ConnectionState<C> connectionState = result;
            return connectionState;
        }
        finally {
            if (this.debug()) {
                this.dprint("<-getConnectionState: " + conn);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectionState<C extends Closeable> {
        final C connection;
        int busyCount;
        int expectedResponseCount;
        ConcurrentQueue.Handle<C> reclaimableHandle;

        ConnectionState(C conn) {
            this.connection = conn;
            this.busyCount = 0;
            this.expectedResponseCount = 0;
            this.reclaimableHandle = null;
        }
    }
}

