/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Context;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.DefaultConnectorHandlerPool;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.Lifecycle;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.RoundRobinSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.SelectorHandlerRunner;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements Runnable,
Lifecycle,
Copyable,
ConnectorHandlerPool {
    private ConcurrentLinkedQueue<Context> contexts;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ComplexSelectorHandler multiReadThreadSelectorHandler = null;
    protected ConnectorHandlerPool connectorHandlerPool = null;
    protected ConcurrentLinkedQueue<SelectorHandler> selectorHandlers;
    protected volatile State state;
    protected ReentrantLock stateLock;
    protected int readThreadsCount = 0;
    protected ReadController[] readThreadControllers;
    private static Logger logger = Logger.getLogger("grizzly");
    private Pipeline<Callable> pipeline;
    protected Collection<ControllerStateListener> stateListeners = new LinkedList<ControllerStateListener>();
    protected AtomicInteger readySelectorHandlerCounter;
    protected AtomicInteger stopedSelectorHandlerCounter;
    private boolean handleReadWriteConcurrently = true;

    public Controller() {
        this.contexts = new ConcurrentLinkedQueue();
        this.stateLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSelect(SelectorHandler selectorHandler) {
        SelectionKey key = null;
        boolean delegateToWorkerThread = false;
        ProtocolChainInstanceHandler pciHandler = null;
        ProtocolChain protocolChain = null;
        Context serverCtx = this.contexts.poll();
        if (serverCtx == null) {
            serverCtx = new Context();
            serverCtx.setController(this);
        }
        serverCtx.setSelectorHandler(selectorHandler);
        try {
            int selectorState = 0;
            if (selectorHandler.getSelectionKeyHandler() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Set DefaultSelectionKeyHandler to SelectorHandler: " + selectorHandler);
                }
                SelectionKeyHandler selectionKeyHandler = this.selectionKeyHandler != null ? this.selectionKeyHandler : new DefaultSelectionKeyHandler(selectorHandler);
                selectorHandler.setSelectionKeyHandler(selectionKeyHandler);
            }
            selectorHandler.preSelect(serverCtx);
            Set<SelectionKey> readyKeys = selectorHandler.select(serverCtx);
            selectorState = readyKeys.size();
            if (this.state == State.STARTED && selectorState != 0) {
                Iterator<SelectionKey> iterator = readyKeys.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    iterator.remove();
                    boolean skipOpWrite = false;
                    if (key.isValid()) {
                        if ((key.readyOps() & 0x10) == 16) {
                            if (this.readThreadsCount > 0 && this.multiReadThreadSelectorHandler.supportsProtocol(selectorHandler.protocol())) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "OP_ACCEPT on " + key + " passed to multi readthread handler");
                                }
                                delegateToWorkerThread = this.multiReadThreadSelectorHandler.onAcceptInterest(key, serverCtx, selectorHandler);
                                continue;
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_ACCEPT on " + key);
                            }
                            delegateToWorkerThread = selectorHandler.onAcceptInterest(key, serverCtx);
                            continue;
                        }
                        if ((key.readyOps() & 8) == 8) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_CONNECT on " + key);
                            }
                            delegateToWorkerThread = selectorHandler.onConnectInterest(key, serverCtx);
                            continue;
                        }
                        if ((key.readyOps() & 1) == 1) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_READ on " + key);
                            }
                            delegateToWorkerThread = selectorHandler.onReadInterest(key, serverCtx);
                            if (!this.handleReadWriteConcurrently) {
                                skipOpWrite = true;
                            }
                        }
                        if (!skipOpWrite && key.isValid() && (key.readyOps() & 4) == 4) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_WRITE on " + key);
                            }
                            delegateToWorkerThread = selectorHandler.onWriteInterest(key, serverCtx);
                        }
                        if (!delegateToWorkerThread) continue;
                        pciHandler = selectorHandler.getProtocolChainInstanceHandler();
                        protocolChain = pciHandler != null ? pciHandler.poll() : this.instanceHandler.poll();
                        Context context = this.pollContext(key, protocolChain);
                        context.setSelectorHandler(selectorHandler);
                        context.setPipeline(selectorHandler.pipeline());
                        context.execute();
                        continue;
                    }
                    selectorHandler.getSelectionKeyHandler().cancel(key);
                }
            }
            delegateToWorkerThread = false;
            selectorHandler.postSelect(serverCtx);
            this.contexts.offer(serverCtx);
        }
        catch (ClosedSelectorException e) {
            this.stateLock.lock();
            try {
                if (this.state != State.STOPPED) {
                    logger.log(Level.SEVERE, "Selector was unexpectedly closed.");
                    this.notifyException(e);
                } else {
                    logger.log(Level.FINE, "doSelect Selector closed");
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
        catch (ClosedChannelException e) {
            if (this.state != State.STOPPED) {
                logger.log(Level.WARNING, "Channel was unexpectedly closed");
                if (key != null) {
                    selectorHandler.getSelectionKeyHandler().cancel(key);
                }
                this.notifyException(e);
            }
        }
        catch (Throwable t) {
            if (key != null) {
                selectorHandler.getSelectionKeyHandler().cancel(key);
            }
            this.notifyException(t);
            logger.log(Level.SEVERE, "doSelect exception", t);
        }
    }

    public void registerKey(SelectionKey key) {
        this.registerKey(key, 1);
    }

    public void registerKey(SelectionKey key, int ops) {
        this.registerKey(key, ops, this.selectorHandlers.peek().protocol());
    }

    public void registerKey(SelectionKey key, int ops, Protocol protocol) {
        if (this.state == State.STOPPED) {
            return;
        }
        this.getSelectorHandler(protocol).register(key, ops);
    }

    public void cancelKey(SelectionKey key) {
        if (this.state == State.STOPPED) {
            return;
        }
        SelectorHandler selectorHandler = this.getSelectorHandler(key.selector());
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectionKey is not associated with known SelectorHandler");
        }
        selectorHandler.getSelectionKeyHandler().cancel(key);
    }

    public Context pollContext(SelectionKey key) {
        return this.pollContext(key, this.instanceHandler.poll());
    }

    protected Context pollContext(SelectionKey key, ProtocolChain protocolChain) {
        Context ctx = this.contexts.poll();
        if (ctx == null) {
            ctx = new Context();
        }
        ctx.setController(this);
        ctx.setSelectionKey(key);
        ctx.setProtocolChain(protocolChain);
        return ctx;
    }

    public void returnContext(Context ctx) {
        this.contexts.offer(ctx);
    }

    public static Logger logger() {
        return logger;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public void addSelectorHandler(SelectorHandler selectorHandler) {
        if (this.selectorHandlers == null) {
            this.selectorHandlers = new ConcurrentLinkedQueue();
        }
        this.selectorHandlers.add(selectorHandler);
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.addSelectorHandler(selectorHandler);
    }

    public SelectorHandler getSelectorHandler(Protocol protocol) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.protocol() != protocol) continue;
            return selectorHandler;
        }
        return null;
    }

    public SelectorHandler getSelectorHandler(Selector selector) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.getSelector() != selector) continue;
            return selectorHandler;
        }
        return null;
    }

    public ConcurrentLinkedQueue getSelectorHandlers() {
        return this.selectorHandlers;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline<Callable> pipeline) {
        this.pipeline = pipeline;
    }

    public int getReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
    }

    public ConnectorHandlerPool getConnectorHandlerPool() {
        return this.connectorHandlerPool;
    }

    public void setConnectorHandlerPool(ConnectorHandlerPool connectorHandlerPool) {
        this.connectorHandlerPool = connectorHandlerPool;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException e) {
            this.notifyException(e);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void copyTo(Copyable copy) {
        Controller copyController = (Controller)copy;
        copyController.contexts = this.contexts;
        copyController.instanceHandler = this.instanceHandler;
        copyController.pipeline = this.pipeline;
        copyController.readThreadControllers = this.readThreadControllers;
        copyController.readThreadsCount = this.readThreadsCount;
        copyController.selectionKeyHandler = this.selectionKeyHandler;
        copyController.stateLock = this.stateLock;
        copyController.state = this.state;
    }

    public void addStateListener(ControllerStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(ControllerStateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    void notifyStarted() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStarted();
        }
    }

    void notifyReady() {
        if (this.readySelectorHandlerCounter.decrementAndGet() == 0) {
            for (ControllerStateListener stateListener : this.stateListeners) {
                stateListener.onReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStopped() {
        if (this.stopedSelectorHandlerCounter.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this.stopedSelectorHandlerCounter;
            synchronized (atomicInteger) {
                this.stopedSelectorHandlerCounter.notifyAll();
            }
            for (ControllerStateListener stateListener : this.stateListeners) {
                stateListener.onStopped();
            }
        }
    }

    void notifyException(Throwable e) {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        if (this.pipeline == null) {
            this.pipeline = new DefaultPipeline();
        }
        if (this.instanceHandler == null) {
            this.instanceHandler = new DefaultProtocolChainInstanceHandler();
        }
        if (this.selectorHandlers == null) {
            this.selectorHandlers = new ConcurrentLinkedQueue();
            TCPSelectorHandler selectorHandler = new TCPSelectorHandler();
            this.selectorHandlers.add(selectorHandler);
        }
        if (this.connectorHandlerPool == null) {
            this.connectorHandlerPool = new DefaultConnectorHandlerPool(this);
        }
        this.pipeline.initPipeline();
        this.pipeline.startPipeline();
        this.stateLock.lock();
        try {
            this.state = State.STARTED;
        }
        finally {
            this.stateLock.unlock();
        }
        this.notifyStarted();
        if (this.readThreadsCount > 0) {
            this.initReadThreads();
            this.multiReadThreadSelectorHandler = new RoundRobinSelectorHandler(this.readThreadControllers);
        }
        int selectorHandlerCount = this.selectorHandlers.size();
        this.readySelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
        this.stopedSelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            SelectorHandlerRunner selectorRunner = new SelectorHandlerRunner(this, selectorHandler);
            if (selectorHandlerCount > 1) {
                new Thread(selectorRunner).start();
                continue;
            }
            selectorRunner.run();
        }
        this.waitUntilSeletorHandlersStop();
        this.selectorHandlers.clear();
        this.pipeline.stopPipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.stateLock.lock();
        try {
            if (this.state != State.STOPPED) {
                this.state = State.STOPPED;
                this.waitUntilSeletorHandlersStop();
                if (this.readThreadsCount > 0) {
                    this.multiReadThreadSelectorHandler.shutdown();
                    this.multiReadThreadSelectorHandler = null;
                    for (ReadController readController : this.readThreadControllers) {
                        try {
                            readController.stop();
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Exception occured when stopping read Controller!", e);
                        }
                    }
                    this.readThreadControllers = null;
                }
            } else {
                logger.log(Level.FINE, "Controller is already in stopped state");
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void pause() throws IOException {
    }

    @Override
    public void resume() throws IOException {
    }

    private void initReadThreads() throws IOException {
        this.readThreadControllers = new ReadController[this.readThreadsCount];
        for (int i = 0; i < this.readThreadsCount; ++i) {
            ReadController controller = new ReadController();
            this.copyTo(controller);
            for (SelectorHandler selectorHandler : this.selectorHandlers) {
                SelectorHandler copySelectorHandler = Cloner.clone(selectorHandler);
                copySelectorHandler.setSelector(null);
                controller.addSelectorHandler(copySelectorHandler);
            }
            controller.setReadThreadsCount(0);
            this.readThreadControllers[i] = controller;
            new Thread(controller).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        boolean result = false;
        if (this.stateLock != null) {
            this.stateLock.lock();
            try {
                result = this.state == State.STARTED;
            }
            finally {
                this.stateLock.unlock();
            }
        }
        return result;
    }

    public ConnectorHandler acquireConnectorHandler(Protocol protocol) {
        return this.connectorHandlerPool.acquireConnectorHandler(protocol);
    }

    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorHandlerPool.releaseConnectorHandler(connectorHandler);
    }

    public boolean isHandleReadWriteConcurrently() {
        return this.handleReadWriteConcurrently;
    }

    public void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
        this.handleReadWriteConcurrently = handleReadWriteConcurrently;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilSeletorHandlersStop() {
        AtomicInteger atomicInteger = this.stopedSelectorHandlerCounter;
        synchronized (atomicInteger) {
            while (this.stopedSelectorHandlerCounter.get() > 0) {
                try {
                    this.stopedSelectorHandlerCounter.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        STOPPED,
        STARTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        UDP,
        TCP,
        TLS,
        CUSTOM;

    }
}

