/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.SelectorHandler;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements Callable {
    private OpType currentOpType;
    private ProtocolChain protocolChain;
    public static final String THROWABLE = "throwable";
    private HashMap<String, Object> attributes = null;
    private SelectionKey key;
    private SelectorHandler selectorHandler;
    private Controller controller;
    private KeyRegistrationState keyRegistrationState = KeyRegistrationState.REGISTER;
    private Pipeline pipeline;
    private IOEvent<Context> ioEvent;

    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void recycle() {
        this.key = null;
        this.keyRegistrationState = KeyRegistrationState.REGISTER;
        this.protocolChain = null;
        this.ioEvent = null;
    }

    public KeyRegistrationState getKeyRegistrationState() {
        return this.keyRegistrationState;
    }

    public void setKeyRegistrationState(KeyRegistrationState keyRegistrationState) {
        this.keyRegistrationState = keyRegistrationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object call() throws Exception {
        Object attachment = this.key.attachment();
        if (this.ioEvent != null && attachment instanceof CallbackHandler) {
            try {
                CallbackHandler callBackHandler = (CallbackHandler)attachment;
                if (this.currentOpType == OpType.OP_READ) {
                    callBackHandler.onRead(this.ioEvent);
                    return null;
                }
                if (this.currentOpType == OpType.OP_WRITE) {
                    callBackHandler.onWrite(this.ioEvent);
                    return null;
                }
                if (this.currentOpType != OpType.OP_CONNECT) return null;
                callBackHandler.onConnect(this.ioEvent);
                return null;
            }
            finally {
                if (this.ioEvent != null) {
                    this.ioEvent.attach(null);
                    this.ioEvent = null;
                }
            }
        }
        SelectionKey currentKey = this.key;
        this.selectorHandler.getSelectionKeyHandler().process(currentKey);
        try {
            this.protocolChain.execute(this);
            return null;
        }
        finally {
            this.selectorHandler.getSelectionKeyHandler().postProcess(currentKey);
        }
    }

    public ProtocolChain getProtocolChain() {
        return this.protocolChain;
    }

    public void setProtocolChain(ProtocolChain protocolChain) {
        this.protocolChain = protocolChain;
    }

    public OpType getCurrentOpType() {
        return this.currentOpType;
    }

    public void setCurrentOpType(OpType currentOpType) {
        this.currentOpType = currentOpType;
    }

    public void execute() throws PipelineFullException {
        this.getPipeline().execute(this);
    }

    public Pipeline getPipeline() {
        if (this.pipeline == null && this.controller != null) {
            this.pipeline = this.controller.getPipeline();
        }
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected void setIOEvent(IOEvent<Context> ioEvent) {
        this.ioEvent = ioEvent;
    }

    protected IOEvent getIOEvent() {
        return this.ioEvent;
    }

    public Controller.Protocol getProtocol() {
        return this.selectorHandler.protocol();
    }

    public void setProtocol(Controller.Protocol protocol) {
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpType {
        OP_READ,
        OP_WRITE,
        OP_CONNECT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyRegistrationState {
        CANCEL,
        REGISTER,
        NONE;

    }
}

