/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.grizzly.util;

import com.sun.grizzly.CallbackHandler;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 *
 * @author Alexey Stashok
 */
public class SelectionKeyOP {
    private int op;
    private SelectionKey key;
    private SelectableChannel channel;
    
    private static ConcurrentLinkedQueue<SelectionKeyOP> readWritePool = 
            new ConcurrentLinkedQueue<SelectionKeyOP>();
    
    private static ConcurrentLinkedQueue<SelectionKeyOP> connectPool = 
            new ConcurrentLinkedQueue<SelectionKeyOP>();
    
    public static SelectionKeyOP aquireSelectionKeyOP(int op) {
        if (op == SelectionKey.OP_READ || op == SelectionKey.OP_WRITE ||
                op == (SelectionKey.OP_WRITE | SelectionKey.OP_READ)) {
            SelectionKeyOP operation = readWritePool.poll();
            if (operation == null) {
                operation = new SelectionKeyOP();
            }
            
            return operation;
        } else if (op == SelectionKey.OP_CONNECT) {
            SelectionKeyOP operation = connectPool.poll();
            if (operation == null) {
                operation = new ConnectSelectionKeyOP();
            }
            
            return operation;
        }
        
        throw new IllegalStateException("Unknown operation or operation is not supported");
    }
    
    public static void releaseSelectionKeyOP(SelectionKeyOP operation) {
        int op = operation.op;
        operation.recycle();
        
        if (op == SelectionKey.OP_READ || op == SelectionKey.OP_WRITE ||
                op == (SelectionKey.OP_WRITE | SelectionKey.OP_READ)) {
            readWritePool.offer(operation);
            return;
        } else if (op == SelectionKey.OP_CONNECT) {
            connectPool.offer(operation);
            return;
        }
        
        throw new IllegalStateException("Unknown operation or operation is not supported");
    }

    private SelectionKeyOP() {
    }
    
    public int getOp() {
        return op;
    }

    public void setOp(int op) {
        this.op = op;
    }

    public SelectionKey getSelectionKey() {
        return key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public SelectableChannel getChannel() {
        return channel;
    }

    public void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }
    
    protected void recycle() {
        op = 0;
        key = null;
        channel = null;
    }
    
    public static class ConnectSelectionKeyOP extends SelectionKeyOP {
        private SocketAddress localAddress;
        private SocketAddress remoteAddress;
        private CallbackHandler callbackHandler;

        public SocketAddress getLocalAddress() {
            return localAddress;
        }

        public void setLocalAddress(SocketAddress localAddress) {
            this.localAddress = localAddress;
        }

        public SocketAddress getRemoteAddress() {
            return remoteAddress;
        }

        public void setRemoteAddress(SocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public CallbackHandler getCallbackHandler() {
            return callbackHandler;
        }

        public void setCallbackHandler(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }
        
        @Override
        protected void recycle() {
            localAddress = null;
            remoteAddress = null;
            callbackHandler = null;
        }
    }
}