/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.grizzly.util;

import com.sun.grizzly.Controller;
import java.lang.reflect.Constructor;
import java.util.logging.Level;

/**
 * Class Cloner creates a clone of given object, 
 * which should implement interface <code>Copyable</code>
 * 
 * @author Alexey Stashok
 */
public class Cloner {
    /**
     * Method creates a clone of given object pattern
     * Pattern parameter should implement <class>Copyable</class> interface
     * 
     * @param pattern represents object, which will be cloned. Should implement <code>Copyable</code>
     * @return clone
     */
    public static <T extends Copyable> T clone(T pattern) {
        try {
            T copy = null;
            
            try {
                // Try default Constructor
                copy = (T) pattern.getClass().newInstance();
            } catch(InstantiationException e) {
                // If didn't succeed with default - try other public constructors
                Constructor[] constructors = pattern.getClass().getConstructors();
                if (constructors.length == 0) {
                    // if there are no public constructors - try others
                    constructors = pattern.getClass().getDeclaredConstructors();
                }
                
                for(Constructor constructor : constructors) {
                    constructor.setAccessible(true);
                    Object[] params = 
                            new Object[constructor.getParameterTypes().length];
                    
                    try {
                        copy = (T) constructor.newInstance(params);
                        break;
                    } catch(InstantiationException ee) {
                    }
                }
            }
            
            if (copy == null) {
                throw new InstantiationException("Could not create " +
                        "an instance of class: " + pattern.getClass().getName());
            }
            
            pattern.copyTo(copy);
            return copy;
        } catch (Exception e) {
            if (Controller.logger().isLoggable(Level.WARNING)) {
                Controller.logger().log(Level.WARNING, "Error copying objects!", e);
            }
            throw new RuntimeException("Error copying objects! " + e.getClass().getName() + ": " + e.getMessage());
        }
    }
}
