/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.grizzly;

import java.nio.channels.SelectionKey;
import com.sun.grizzly.Controller.State;

/**
 * Class is responsible for processing certain (single)
 * <code>SelectorHandler</code>
 * 
 * @author Alexey Stashok
 */
public class SelectorHandlerRunner implements Runnable {

    private final SelectorHandler selectorHandler;
    private final Controller controller;
    
    public SelectorHandlerRunner(Controller controller, SelectorHandler selectorHandler) {
        this.controller = controller;
        this.selectorHandler = selectorHandler;
    }
    
    public SelectorHandler getSelectorHandler() {
        return selectorHandler;
    }
    
    public void run() {
        boolean firstTimeSelect = true;
        try {
            while (controller.state == State.STARTED) {
                // State changed inside the loop
                if (controller.state != State.STARTED) {
                    break;
                }
                controller.doSelect(selectorHandler);

                if (firstTimeSelect) {
                    firstTimeSelect = false;
                    controller.notifyReady();
                }
            }

            SelectionKeyHandler selectionKeyHandler = selectorHandler.getSelectionKeyHandler();

            for (SelectionKey selectionKey : selectorHandler.keys()) {
                selectionKeyHandler.close(selectionKey);
            }

            selectorHandler.shutdown();
        } finally {
            controller.notifyStopped();
        }
    }
}