/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.util.MessageUtils;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlMessage;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AfterAddToParentEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectStagePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 8281381763781233640L;
    private static final String HAS_MESSAGES = ProjectStagePhaseListener.class.getName() + ".HAS_MESSAGES";
    private static final String HAS_COMMAND_NO_FORM = ProjectStagePhaseListener.class.getName() + ".HAS_COMMAND_NO_FORM";

    public ProjectStagePhaseListener() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.subscribeSystemEventListener(ctx, AfterAddToParentEvent.class, new MessageListener(), UIMessage.class, UIMessages.class, HtmlMessage.class, HtmlMessages.class);
        this.subscribeSystemEventListener(ctx, AfterAddToParentEvent.class, new CommandListener(), UICommand.class, HtmlCommandButton.class, HtmlCommandLink.class);
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        Map attributes = context.getAttributes();
        if (!attributes.containsKey(HAS_MESSAGES)) {
            this.addMessagesComponent(context);
        }
        if (attributes.containsKey(HAS_COMMAND_NO_FORM)) {
            context.addMessage(null, MessageUtils.getExceptionMessage("com.sun.faces.COMMAND_NOT_NESTED_WITHIN_FORM", new Object[0]));
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private void subscribeSystemEventListener(FacesContext ctx, Class<? extends SystemEvent> systemEvent, SystemEventListener listener, Class<?> ... sources) {
        Application app = ctx.getApplication();
        for (Class<?> source : sources) {
            app.subscribeToEvent(systemEvent, source, listener);
        }
    }

    private void addMessagesComponent(FacesContext context) {
        Application app = context.getApplication();
        UIViewRoot root = context.getViewRoot();
        UIComponent panel = app.createComponent("javax.faces.Panel");
        panel.setRendererType("javax.faces.Grid");
        UIOutput output = (UIOutput)app.createComponent("javax.faces.Output");
        output.setValue((Object)"ProjectStage[Development]: Messages - Add your own message handling to prevent this from appearing.");
        output.getAttributes().put("style", "color: red");
        panel.getAttributes().put("columns", 1);
        panel.getFacets().put("caption", output);
        UIComponent messages = app.createComponent("javax.faces.Messages");
        messages.setTransient(true);
        Map attrs = messages.getAttributes();
        attrs.put("style", "");
        attrs.put("layout", "table");
        attrs.put("title", "Development Mode Messages");
        attrs.put("style", "font-family: 'Trebuchet MS', Verdana, Arial, Sans-Serif; font-size: small; color: #339;");
        attrs.put("tooltip", Boolean.TRUE);
        messages.setRendererType("javax.faces.Messages");
        panel.getChildren().add(messages);
        root.addComponentResource(context, panel, "body");
    }

    private static class CommandListener
    implements SystemEventListener {
        private CommandListener() {
        }

        public void processEvent(SystemEvent event) throws AbortProcessingException {
            UICommand command = (UICommand)event.getSource();
            for (UIComponent parent = command.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof UIForm)) continue;
                return;
            }
            FacesContext ctx = FacesContext.getCurrentInstance();
            ctx.getAttributes().put(HAS_COMMAND_NO_FORM, Boolean.TRUE);
        }

        public boolean isListenerForSource(Object source) {
            return source instanceof UICommand;
        }
    }

    private static class MessageListener
    implements SystemEventListener {
        private MessageListener() {
        }

        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext ctx = FacesContext.getCurrentInstance();
            ctx.getAttributes().put(HAS_MESSAGES, Boolean.TRUE);
        }

        public boolean isListenerForSource(Object source) {
            return source instanceof UIMessage || source instanceof UIMessages;
        }
    }
}

