/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.TagAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class TagAttributes {
    private static final TagAttribute[] EMPTY = new TagAttribute[0];
    private final TagAttribute[] attrs;
    private final String[] ns;
    private final List nsattrs;

    public TagAttributes(TagAttribute[] attrs) {
        this.attrs = attrs;
        int i = 0;
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < this.attrs.length; ++i) {
            set.add(this.attrs[i].getNamespace());
        }
        this.ns = set.toArray(new String[set.size()]);
        Arrays.sort(this.ns);
        this.nsattrs = new ArrayList();
        for (i = 0; i < this.ns.length; ++i) {
            this.nsattrs.add(i, new ArrayList());
        }
        int nsIdx = 0;
        for (i = 0; i < this.attrs.length; ++i) {
            nsIdx = Arrays.binarySearch(this.ns, this.attrs[i].getNamespace());
            ((List)this.nsattrs.get(nsIdx)).add(this.attrs[i]);
        }
        for (i = 0; i < this.ns.length; ++i) {
            List r = (List)this.nsattrs.get(i);
            this.nsattrs.set(i, r.toArray(new TagAttribute[r.size()]));
        }
    }

    public TagAttribute[] getAll() {
        return this.attrs;
    }

    public TagAttribute get(String localName) {
        return this.get("", localName);
    }

    public TagAttribute get(String ns, String localName) {
        int idx;
        if (ns != null && localName != null && (idx = Arrays.binarySearch(this.ns, ns)) >= 0) {
            TagAttribute[] uia = (TagAttribute[])this.nsattrs.get(idx);
            for (int i = 0; i < uia.length; ++i) {
                if (!localName.equals(uia[i].getLocalName())) continue;
                return uia[i];
            }
        }
        return null;
    }

    public TagAttribute[] getAll(String namespace) {
        int idx = 0;
        idx = namespace == null ? Arrays.binarySearch(this.ns, "") : Arrays.binarySearch(this.ns, namespace);
        if (idx >= 0) {
            return (TagAttribute[])this.nsattrs.get(idx);
        }
        return EMPTY;
    }

    public String[] getNamespaces() {
        return this.ns;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.attrs.length; ++i) {
            sb.append(this.attrs[i]);
            sb.append(' ');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

