/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FactoryConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACTORY = "factory";
    private static final String APPLICATION_FACTORY = "application-factory";
    private static final String FACES_CONTEXT_FACTORY = "faces-context-factory";
    private static final String LIFECYCLE_FACTORY = "lifecycle-factory";
    private static final String RENDER_KIT_FACTORY = "render-kit-factory";
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};

    public void process(Document[] documents) throws Exception {
        AtomicInteger facesContextFactoryCount = new AtomicInteger(0);
        AtomicInteger applicationFactoryCount = new AtomicInteger(0);
        for (int i = 0; i < documents.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documents[i].getDocumentURI()));
            }
            String namespace = documents[i].getDocumentElement().getNamespaceURI();
            NodeList factories = documents[i].getDocumentElement().getElementsByTagNameNS(namespace, FACTORY);
            if (factories == null || factories.getLength() <= 0) continue;
            this.processFactories(factories, namespace, facesContextFactoryCount, applicationFactoryCount);
        }
        this.wrapFactories(applicationFactoryCount.get(), facesContextFactoryCount.get());
        this.verifyFactoriesExist();
        this.invokeNext(documents);
    }

    private void processFactories(NodeList factories, String namespace, AtomicInteger fcCount, AtomicInteger appCount) {
        int size = factories.getLength();
        for (int i = 0; i < size; ++i) {
            Node factory = factories.item(i);
            NodeList children = ((Element)factory).getElementsByTagNameNS(namespace, "*");
            int csize = children.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (APPLICATION_FACTORY.equals(n.getLocalName())) {
                    appCount.incrementAndGet();
                    FactoryConfigProcessor.setFactory("javax.faces.application.ApplicationFactory", this.getNodeText(n));
                    continue;
                }
                if (LIFECYCLE_FACTORY.equals(n.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.lifecycle.LifecycleFactory", this.getNodeText(n));
                    continue;
                }
                if (FACES_CONTEXT_FACTORY.equals(n.getLocalName())) {
                    fcCount.incrementAndGet();
                    FactoryConfigProcessor.setFactory("javax.faces.context.FacesContextFactory", this.getNodeText(n));
                    continue;
                }
                if (!RENDER_KIT_FACTORY.equals(n.getLocalName())) continue;
                FactoryConfigProcessor.setFactory("javax.faces.render.RenderKitFactory", this.getNodeText(n));
            }
        }
    }

    private static void setFactory(String factoryName, String factoryImpl) {
        if (factoryName != null && factoryImpl != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling FactoryFinder.setFactory({0}, {1})", factoryName, factoryImpl));
            }
            FactoryFinder.setFactory((String)factoryName, (String)factoryImpl);
        }
    }

    private void verifyFactoriesExist() {
        int len = FACTORY_NAMES.length;
        for (int i = 0; i < len; ++i) {
            try {
                FactoryFinder.getFactory((String)FACTORY_NAMES[i]);
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(MessageFormat.format("Factory ''{0}'' was not configured properly.", FACTORY_NAMES[i]), e);
            }
        }
    }

    private void wrapFactories(int appCount, int fcCount) {
        if (appCount > 1) {
            this.addInjectionApplicationFactory();
        }
        if (fcCount > 1) {
            this.addInjectionFacesContextFactory();
        }
    }

    private void addInjectionApplicationFactory() {
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)"com.sun.faces.application.InjectionApplicationFactory");
    }

    private void addInjectionFacesContextFactory() {
        FactoryFinder.setFactory((String)"javax.faces.context.FacesContextFactory", (String)"com.sun.faces.context.InjectionFacesContextFactory");
    }
}

