/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.render.FacesRenderKit;
import javax.faces.render.FacesRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES;
    Map<Class<?>, FacesRenderer> annotatedRenderers;
    Map<Class<?>, FacesRenderKit> annotatedRenderKits;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (annotation instanceof FacesRenderer) {
            if (this.annotatedRenderers == null) {
                this.annotatedRenderers = new HashMap();
            }
            this.annotatedRenderers.put(target, (FacesRenderer)annotation);
        } else if (annotation instanceof FacesRenderKit) {
            if (this.annotatedRenderKits == null) {
                this.annotatedRenderKits = new HashMap();
            }
            this.annotatedRenderKits.put(target, (FacesRenderKit)annotation);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void push(FacesContext ctx) {
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        if (this.annotatedRenderKits != null) {
            for (Map.Entry<Class<?>, FacesRenderKit> entry : this.annotatedRenderKits.entrySet()) {
                Class<?> rkClass = entry.getKey();
                FacesRenderKit rka = entry.getValue();
                try {
                    rkf.addRenderKit(rka.value(), (RenderKit)rkClass.newInstance());
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
        if (this.annotatedRenderers != null) {
            for (Map.Entry<Class<?>, FacesRenderKit> entry : this.annotatedRenderers.entrySet()) {
                Class<?> rClass = entry.getKey();
                FacesRenderer ra = (FacesRenderer)entry.getValue();
                try {
                    RenderKit rk = rkf.getRenderKit(ctx, ra.renderKitId());
                    rk.addRenderer(ra.componentFamily(), ra.rendererType(), (Renderer)rClass.newInstance());
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
    }

    static {
        ArrayList<Class> handles = new ArrayList<Class>(2);
        handles.add(FacesRenderKit.class);
        handles.add(FacesRenderer.class);
        HANDLES = Collections.unmodifiableCollection(handles);
    }
}

