/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.annotation.AnnotationManager;
import com.sun.faces.util.FacesLogger;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesAnnotationHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ApplicationPostConstructEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandler
extends FacesAnnotationHandler
implements SystemEventListener {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String ANNOTATIONS_SCAN_TASK_KEY = AnnotationHandler.class.getName() + "_ANNOTATION_SCAN_TASK";
    private Set<String> annotatedClasses;
    private boolean applicationInitialized;
    private Application application = FacesContext.getCurrentInstance().getApplication();

    public AnnotationHandler() {
        this.application.subscribeToEvent(ApplicationPostConstructEvent.class, Application.class, (SystemEventListener)this);
    }

    public Set<String> getClassNamesWithFacesAnnotations(FacesContext context) {
        if (this.annotatedClasses == null) {
            this.annotatedClasses = this.getAnnotatedClasses(context);
        }
        return this.annotatedClasses;
    }

    public void processAnnotatedClasses(FacesContext context, Set<String> annotatedClassnames) {
        if (!this.applicationInitialized) {
            if (annotatedClassnames == null || !annotatedClassnames.isEmpty()) {
                ApplicationAssociate associate = ApplicationAssociate.getInstance(context.getExternalContext());
                if (associate != null) {
                    AnnotationManager manager = associate.getAnnotationManager();
                    assert (manager != null);
                    manager.applyConfigAnntations(context, annotatedClassnames);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("No ApplicationAssociate available.");
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No JSF annotated artifacts provided.");
            }
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Application has been initialized.  Calls to AnnotationHandler.processAnnotatedClasses() will be ignored.");
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        this.applicationInitialized = true;
        this.application.unsubscribeFromEvent(ApplicationPostConstructEvent.class, Application.class, (SystemEventListener)this);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof Application;
    }

    private Set<String> getAnnotatedClasses(FacesContext ctx) {
        Map appMap = ctx.getExternalContext().getApplicationMap();
        Future scanTask = (Future)appMap.remove(ANNOTATIONS_SCAN_TASK_KEY);
        try {
            return scanTask != null ? (Set)scanTask.get() : Collections.emptySet();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }
}

