/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.DebugObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

public class DebugUtil {
    private static final Logger LOGGER = Logger.getLogger(DebugUtil.class.getPackage().getName());
    private static boolean keepWaiting = true;
    private static int curDepth = 0;

    public DebugUtil() {
        this.init();
    }

    protected void init() {
    }

    public static void setKeepWaiting(boolean bl) {
        keepWaiting = bl;
    }

    public static void waitForDebugger() {
        while (keepWaiting) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("DebugUtil.waitForDebugger(): Exception: " + interruptedException.getMessage());
            }
        }
    }

    private static void indentPrintln(Writer writer, String string) {
        block3: {
            try {
                for (int i = 0; i < curDepth; ++i) {
                    writer.write("  ");
                }
                writer.write(string + "\n");
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                LOGGER.log(Level.FINEST, "Unable to write indent", iOException);
            }
        }
    }

    private static void assertSerializability(StringBuilder stringBuilder, Object object) {
        DebugObjectOutputStream debugObjectOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            debugObjectOutputStream = new DebugObjectOutputStream(objectOutputStream);
            debugObjectOutputStream.writeObject(object);
        }
        catch (IOException iOException) {
            List<Object> list = debugObjectOutputStream.getStack();
            stringBuilder.append("Path to non-Serializable Object: \n");
            for (Object object2 : list) {
                stringBuilder.append(object2.toString()).append("\n");
            }
        }
    }

    private static void indentPrintln(Logger logger, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null == object ? "null" : object.toString();
        for (int i = 0; i < curDepth; ++i) {
            stringBuilder.append("  ");
        }
        stringBuilder.append(string + "\n");
        if (!(object instanceof String)) {
            DebugUtil.assertSerializability(stringBuilder, object);
        }
        logger.severe(stringBuilder.toString());
    }

    public static String printTree(UIComponent uIComponent) {
        FastStringWriter fastStringWriter = new FastStringWriter(1024);
        DebugUtil.printTree(uIComponent, (Writer)fastStringWriter);
        return ((Object)fastStringWriter).toString();
    }

    public static void printTree(UIComponent uIComponent, PrintStream printStream) {
        try {
            PrintWriter printWriter = new PrintWriter(new PrintStream((OutputStream)printStream, true, "UTF-8"));
            DebugUtil.printTree(uIComponent, (Writer)printWriter);
            printWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException.getMessage());
        }
    }

    public static void printTree(UIComponent uIComponent, Logger logger, Level level) {
        StringWriter stringWriter = new StringWriter();
        DebugUtil.printTree(uIComponent, (Writer)stringWriter);
        logger.log(level, stringWriter.toString());
    }

    public static void printTree(UIComponent uIComponent, Writer writer) {
        Object object;
        Object object2;
        if (null == uIComponent) {
            return;
        }
        Object object3 = null;
        DebugUtil.indentPrintln(writer, "id:" + uIComponent.getId());
        DebugUtil.indentPrintln(writer, "type:" + uIComponent.getClass().getName());
        if (uIComponent instanceof UISelectOne) {
            object2 = null;
            try {
                object2 = RenderKitUtils.getSelectItems(FacesContext.getCurrentInstance(), uIComponent);
            }
            catch (Exception exception) {
                DebugUtil.indentPrintln(writer, " { SelectItem(s) not resolvable at this point in time }");
            }
            if (object2 != null) {
                DebugUtil.indentPrintln(writer, " {");
                while (object2.hasNext()) {
                    object = (SelectItem)object2.next();
                    DebugUtil.indentPrintln(writer, "\t value = " + object.getValue() + ", label = " + object.getLabel() + ", description = " + object.getDescription());
                }
                DebugUtil.indentPrintln(writer, " }");
            }
        } else {
            object2 = null;
            if (uIComponent instanceof ValueHolder) {
                object2 = uIComponent.getValueExpression("value");
                try {
                    object3 = ((ValueHolder)uIComponent).getValue();
                }
                catch (Exception exception) {
                    object3 = "UNAVAILABLE";
                }
            }
            if (object2 != null) {
                DebugUtil.indentPrintln(writer, "expression/value = " + object2.getExpressionString() + " : " + object3);
            } else {
                DebugUtil.indentPrintln(writer, "value = " + object3);
            }
            object = uIComponent.getAttributes().keySet().iterator();
            if (object != null) {
                while (object.hasNext()) {
                    String string;
                    Object object4 = (String)object.next();
                    object2 = uIComponent.getValueExpression((String)object4);
                    String string2 = null;
                    if (object2 != null) {
                        string2 = object2.getExpressionString();
                    }
                    try {
                        string = uIComponent.getAttributes().get(object4).toString();
                    }
                    catch (Exception exception) {
                        string = "UNAVAILABLE";
                    }
                    if (string2 != null) {
                        DebugUtil.indentPrintln(writer, "attr = " + (String)object4 + " : [" + string2 + " : " + string + " ]");
                        continue;
                    }
                    DebugUtil.indentPrintln(writer, "attr = " + (String)object4 + " : " + string);
                }
            }
        }
        ++curDepth;
        object2 = uIComponent.getChildren().iterator();
        for (Object object4 : uIComponent.getFacets().values()) {
            DebugUtil.printTree(object4, writer);
        }
        while (object2.hasNext()) {
            DebugUtil.printTree((UIComponent)object2.next(), writer);
        }
        --curDepth;
    }

    public static void simplePrintTree(UIComponent uIComponent, String string, Writer writer) {
        if (null == uIComponent) {
            return;
        }
        if (string.equals(uIComponent.getClientId())) {
            DebugUtil.indentPrintln(writer, "+id: " + uIComponent.getId() + "  <===============");
        } else {
            DebugUtil.indentPrintln(writer, "+id: " + uIComponent.getId());
        }
        DebugUtil.indentPrintln(writer, " type: " + uIComponent.toString());
        ++curDepth;
        for (UIComponent uIComponent2 : uIComponent.getFacets().values()) {
            DebugUtil.simplePrintTree(uIComponent2, string, writer);
        }
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            DebugUtil.simplePrintTree(uIComponent2, string, writer);
        }
        --curDepth;
    }

    public static void printState(Map map, Logger logger) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            String string = k instanceof Serializable ? "true" : "+_+_+_+FALSE+_+_+_+_";
            String string2 = v instanceof Serializable ? "true" : "+_+_+_+FALSE+_+_+_+_";
            logger.severe("key: " + k.toString() + " class:" + k.getClass() + " Serializable: " + string);
            logger.severe("value: " + v.toString() + " class:" + k.getClass() + " Serializable: " + string);
            if (!(v instanceof Object[])) continue;
            DebugUtil.printTree((Object[])v, logger);
        }
    }

    public static void printTree(Object[] objectArray, Writer writer) {
        if (null == objectArray) {
            DebugUtil.indentPrintln(writer, "null");
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (null == object) {
                DebugUtil.indentPrintln(writer, "null");
                continue;
            }
            if (object.getClass().isArray()) {
                ++curDepth;
                DebugUtil.printTree((Object[])object, writer);
                --curDepth;
                continue;
            }
            DebugUtil.indentPrintln(writer, object.toString());
        }
    }

    public static void printTree(Object[] objectArray, Logger logger) {
        if (null == objectArray) {
            DebugUtil.indentPrintln(logger, (Object)"null");
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (null == object) {
                DebugUtil.indentPrintln(logger, (Object)"null");
                continue;
            }
            if (object.getClass().isArray()) {
                ++curDepth;
                DebugUtil.printTree((Object[])object, logger);
                --curDepth;
                continue;
            }
            if (object instanceof List) {
                DebugUtil.printList((List)object, logger);
                continue;
            }
            DebugUtil.indentPrintln(logger, object);
        }
    }

    public static void printList(List list, Logger logger) {
        for (Object e : list) {
            if (e instanceof List) {
                ++curDepth;
                DebugUtil.printList((List)e, logger);
                --curDepth;
                continue;
            }
            DebugUtil.indentPrintln(logger, e);
        }
    }
}

