/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;

public class CheckboxRenderer
extends HtmlBasicInputRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTBOOLEANCHECKBOX);

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldDecode(uIComponent)) {
            return;
        }
        String string = this.decodeBehaviors(facesContext, uIComponent);
        if (string == null) {
            string = uIComponent.getClientId(facesContext);
        }
        assert (string != null);
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        boolean bl = CheckboxRenderer.isChecked((String)map.get(string));
        this.setSubmittedValue(uIComponent, bl);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new value after decoding: {0}", bl);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uIComponent, Object object) throws ConverterException {
        return object instanceof Boolean ? object : Boolean.valueOf(object.toString());
    }

    protected void getEndTextToRender(FacesContext facesContext, UIComponent uIComponent, String string) throws IOException {
        String string2;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        responseWriter.startElement("input", uIComponent);
        this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        responseWriter.writeAttribute("type", (Object)"checkbox", "type");
        responseWriter.writeAttribute("name", (Object)uIComponent.getClientId(facesContext), "clientId");
        if (Boolean.valueOf(string).booleanValue()) {
            responseWriter.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
        if (null != (string2 = (String)uIComponent.getAttributes().get("styleClass"))) {
            responseWriter.writeAttribute("class", (Object)string2, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(facesContext, responseWriter, uIComponent, ATTRIBUTES, CheckboxRenderer.getNonOnClickSelectBehaviors(uIComponent));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(responseWriter, uIComponent);
        RenderKitUtils.renderSelectOnclick(facesContext, uIComponent, false);
        responseWriter.endElement("input");
    }

    private static boolean isChecked(String string) {
        return "on".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }
}

