/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class BaseTableRenderer
extends HtmlBasicRenderer {
    protected abstract void renderHeader(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;

    protected abstract void renderFooter(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;

    protected abstract void renderRow(FacesContext var1, UIComponent var2, UIComponent var3, ResponseWriter var4) throws IOException;

    protected void renderTableStart(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter, Attribute[] attributeArray) throws IOException {
        responseWriter.startElement("table", uIComponent);
        this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        String string = (String)uIComponent.getAttributes().get("styleClass");
        if (string != null) {
            responseWriter.writeAttribute("class", (Object)string, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(facesContext, responseWriter, uIComponent, attributeArray);
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    protected void renderTableEnd(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        responseWriter.endElement("table");
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    protected void renderCaption(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        UIComponent uIComponent2 = this.getFacet(uIComponent, "caption");
        if (uIComponent2 != null) {
            String string = (String)uIComponent.getAttributes().get("captionClass");
            String string2 = (String)uIComponent.getAttributes().get("captionStyle");
            responseWriter.startElement("caption", uIComponent);
            if (string != null) {
                responseWriter.writeAttribute("class", (Object)string, "captionClass");
            }
            if (string2 != null) {
                responseWriter.writeAttribute("style", (Object)string2, "captionStyle");
            }
            this.encodeRecursive(facesContext, uIComponent2);
            responseWriter.endElement("caption");
        }
    }

    protected void renderTableBodyStart(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        responseWriter.startElement("tbody", uIComponent);
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    protected void renderTableBodyEnd(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        responseWriter.endElement("tbody");
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    protected void renderRowStart(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        responseWriter.startElement("tr", uIComponent);
        if (tableMetaInfo.rowClasses.length > 0) {
            responseWriter.writeAttribute("class", (Object)tableMetaInfo.getCurrentRowClass(), "rowClasses");
        }
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    protected void renderRowEnd(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        responseWriter.endElement("tr");
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    protected TableMetaInfo getMetaInfo(FacesContext facesContext, UIComponent uIComponent) {
        String string = this.createKey(uIComponent);
        Map map = facesContext.getAttributes();
        TableMetaInfo tableMetaInfo = (TableMetaInfo)map.get(string);
        if (tableMetaInfo == null) {
            tableMetaInfo = new TableMetaInfo(uIComponent);
            map.put(string, tableMetaInfo);
        }
        return tableMetaInfo;
    }

    protected void clearMetaInfo(FacesContext facesContext, UIComponent uIComponent) {
        facesContext.getAttributes().remove(this.createKey(uIComponent));
    }

    protected String createKey(UIComponent uIComponent) {
        return TableMetaInfo.KEY + '_' + uIComponent.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TableMetaInfo {
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        public static final String KEY = TableMetaInfo.class.getName();
        public final String[] rowClasses;
        public final String[] columnClasses;
        public final List<UIColumn> columns;
        public final boolean hasHeaderFacets;
        public final boolean hasFooterFacets;
        public final int columnCount;
        public int columnStyleCounter;
        public int rowStyleCounter;

        public TableMetaInfo(UIComponent uIComponent) {
            this.rowClasses = TableMetaInfo.getRowClasses(uIComponent);
            this.columnClasses = TableMetaInfo.getColumnClasses(uIComponent);
            this.columns = TableMetaInfo.getColumns(uIComponent);
            this.columnCount = this.columns.size();
            this.hasHeaderFacets = TableMetaInfo.hasFacet("header", this.columns);
            this.hasFooterFacets = TableMetaInfo.hasFacet("footer", this.columns);
        }

        public void newRow() {
            this.columnStyleCounter = 0;
        }

        public String getCurrentColumnClass() {
            String string = null;
            if (this.columnStyleCounter < this.columnClasses.length && this.columnStyleCounter <= this.columnCount) {
                string = this.columnClasses[this.columnStyleCounter++];
            }
            return string != null && string.length() > 0 ? string : null;
        }

        public String getCurrentRowClass() {
            String string = this.rowClasses[this.rowStyleCounter++];
            if (this.rowStyleCounter >= this.rowClasses.length) {
                this.rowStyleCounter = 0;
            }
            return string;
        }

        private static String[] getColumnClasses(UIComponent uIComponent) {
            String string = (String)uIComponent.getAttributes().get("columnClasses");
            if (string == null) {
                return EMPTY_STRING_ARRAY;
            }
            Map map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
            return Util.split(map, string.trim(), ",");
        }

        private static List<UIColumn> getColumns(UIComponent uIComponent) {
            if (uIComponent instanceof UIData) {
                int n = uIComponent.getChildCount();
                if (n > 0) {
                    ArrayList<UIColumn> arrayList = new ArrayList<UIColumn>(n);
                    for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                        if (!(uIComponent2 instanceof UIColumn) || !uIComponent2.isRendered()) continue;
                        arrayList.add((UIColumn)uIComponent2);
                    }
                    return arrayList;
                }
                return Collections.emptyList();
            }
            Object v = uIComponent.getAttributes().get("columns");
            int n = v != null && v instanceof Integer ? (Integer)v : 2;
            if (n < 1) {
                n = 1;
            }
            ArrayList<UIColumn> arrayList = new ArrayList<UIColumn>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new UIColumn());
            }
            return arrayList;
        }

        private static boolean hasFacet(String string, List<UIColumn> list) {
            if (!list.isEmpty()) {
                for (UIColumn uIColumn : list) {
                    if (uIColumn.getFacetCount() <= 0 || !uIColumn.getFacets().containsKey(string)) continue;
                    return true;
                }
            }
            return false;
        }

        private static String[] getRowClasses(UIComponent uIComponent) {
            String string = (String)uIComponent.getAttributes().get("rowClasses");
            if (string == null) {
                return EMPTY_STRING_ARRAY;
            }
            Map map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
            return Util.split(map, string.trim(), ",");
        }
    }
}

