/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.component.validator.ComponentValidators;
import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.HashSet;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import javax.faces.view.facelets.TagHandlerDelegate;
import javax.faces.view.facelets.ValidatorHandler;

public class ValidatorTagHandlerDelegateImpl
extends TagHandlerDelegate
implements AttachedObjectHandler {
    protected final ValidatorHandler owner;
    private final boolean wrapping;

    public ValidatorTagHandlerDelegateImpl(ValidatorHandler validatorHandler) {
        this.owner = validatorHandler;
        this.wrapping = this.isWrapping();
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        ComponentSupport.copyPassthroughAttributes(faceletContext, uIComponent, this.owner.getTag());
        if (this.wrapping) {
            this.applyWrapping(faceletContext, uIComponent);
        } else {
            this.applyNested(faceletContext, uIComponent);
        }
    }

    public MetaRuleset createMetaRuleset(Class clazz) {
        Util.notNull("type", clazz);
        MetaRulesetImpl metaRulesetImpl = new MetaRulesetImpl(this.owner.getTag(), clazz);
        return metaRulesetImpl.ignore("binding").ignore("disabled").ignore("for");
    }

    public void applyAttachedObject(FacesContext facesContext, UIComponent uIComponent) {
        FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
        EditableValueHolder editableValueHolder = (EditableValueHolder)uIComponent;
        if (this.owner.isDisabled(faceletContext)) {
            HashSet<String> hashSet = (HashSet<String>)RequestStateManager.get(facesContext, "com.sun.faces.DISABLED_VALIDATORS");
            if (hashSet == null) {
                hashSet = new HashSet<String>(3);
                RequestStateManager.set(facesContext, "com.sun.faces.DISABLED_VALIDATORS", hashSet);
            }
            hashSet.add(this.owner.getValidatorId(faceletContext));
            return;
        }
        ValueExpression valueExpression = null;
        Validator validator = null;
        if (this.owner.getBinding() != null) {
            valueExpression = this.owner.getBinding().getValueExpression(faceletContext, Validator.class);
            validator = (Validator)valueExpression.getValue((ELContext)faceletContext);
        }
        if (validator == null) {
            validator = this.createValidator(faceletContext);
            if (valueExpression != null) {
                valueExpression.setValue((ELContext)faceletContext, (Object)validator);
            }
        }
        if (validator == null) {
            throw new TagException(this.owner.getTag(), "No Validator was created");
        }
        this.owner.setAttributes(faceletContext, (Object)validator);
        Validator[] validatorArray = editableValueHolder.getValidators();
        boolean bl = false;
        for (Validator validator2 : validatorArray) {
            if (!validator2.getClass().equals(validator.getClass())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            editableValueHolder.addValidator(validator);
        }
    }

    public String getFor() {
        String string = null;
        TagAttribute tagAttribute = this.owner.getTagAttribute("for");
        if (null != tagAttribute) {
            if (tagAttribute.isLiteral()) {
                string = tagAttribute.getValue();
            } else {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
                string = (String)tagAttribute.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
            }
        }
        return string;
    }

    protected ComponentValidators.ValidatorInfo createValidatorInfo(FaceletContext faceletContext) {
        return new ComponentValidators.ValidatorInfo(faceletContext, this.owner);
    }

    private boolean isWrapping() {
        return this.owner.getValidatorConfig().getNextHandler() instanceof TagHandler || this.owner.getValidatorConfig().getNextHandler() instanceof CompositeFaceletHandler;
    }

    private void applyWrapping(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        ComponentValidators componentValidators = ComponentValidators.getValidators(faceletContext.getFacesContext(), true);
        componentValidators.pushValidatorInfo(this.createValidatorInfo(faceletContext));
        this.owner.getValidatorConfig().getNextHandler().apply(faceletContext, uIComponent);
        componentValidators.popValidatorInfo();
    }

    private void applyNested(FaceletContext faceletContext, UIComponent uIComponent) {
        if (!ComponentHandler.isNew((UIComponent)uIComponent)) {
            return;
        }
        if (uIComponent instanceof EditableValueHolder) {
            this.applyAttachedObject(faceletContext.getFacesContext(), uIComponent);
        } else if (UIComponent.isCompositeComponent((UIComponent)uIComponent)) {
            if (null == this.owner.getFor()) {
                throw new TagException(this.owner.getTag(), "validator tags nested within composite components must have a non-null \"for\" attribute");
            }
            CompositeComponentTagHandler.getAttachedObjectHandlers(uIComponent).add((AttachedObjectHandler)this.owner);
        } else {
            throw new TagException(this.owner.getTag(), "Parent not an instance of EditableValueHolder: " + uIComponent);
        }
    }

    private Validator createValidator(FaceletContext faceletContext) {
        String string = this.owner.getValidatorId(faceletContext);
        if (string == null) {
            throw new TagException(this.owner.getTag(), "A validator id was not specified. Typically the validator id is set in the constructor ValidateHandler(ValidatorConfig)");
        }
        return faceletContext.getFacesContext().getApplication().createValidator(string);
    }
}

