/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationStateInfo;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MostlySingletonSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateContext {
    private static final String KEY = StateContext.class.getName() + "_KEY";
    private static final String MARK_CREATED_REMOVED = StateContext.class.getName() + "_MARK_CREATED_REMOVED";
    private boolean partial;
    private boolean partialLocked;
    private boolean trackMods = true;
    private AddRemoveListener modListener;
    private ApplicationStateInfo stateInfo;
    private WeakReference<UIViewRoot> viewRootRef = new WeakReference<Object>(null);
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();

    private StateContext(ApplicationStateInfo applicationStateInfo) {
        this.stateInfo = applicationStateInfo;
    }

    public static void release(FacesContext facesContext) {
        StateContext stateContext = (StateContext)facesContext.getAttributes().get(KEY);
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot != null && stateContext.modListener != null) {
            uIViewRoot.unsubscribeFromViewEvent(PostAddToViewEvent.class, (SystemEventListener)stateContext.modListener);
            uIViewRoot.unsubscribeFromViewEvent(PreRemoveFromViewEvent.class, (SystemEventListener)stateContext.modListener);
        }
        facesContext.getAttributes().remove(KEY);
    }

    public static StateContext getStateContext(FacesContext facesContext) {
        StateContext stateContext = (StateContext)facesContext.getAttributes().get(KEY);
        if (stateContext == null) {
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
            ApplicationStateInfo applicationStateInfo = applicationAssociate.getApplicationStateInfo();
            stateContext = new StateContext(applicationStateInfo);
            facesContext.getAttributes().put(KEY, stateContext);
        }
        return stateContext;
    }

    public boolean isPartialStateSaving(FacesContext facesContext, String string) {
        UIViewRoot uIViewRoot;
        UIViewRoot uIViewRoot2 = facesContext.getViewRoot();
        if (uIViewRoot2 != (uIViewRoot = (UIViewRoot)this.viewRootRef.get())) {
            this.viewRootRef = new WeakReference<UIViewRoot>(uIViewRoot2);
            if (uIViewRoot != null) {
                this.modListener = null;
                this.partialLocked = false;
            }
        }
        if (!this.partialLocked) {
            if (string == null) {
                string = uIViewRoot2 != null ? uIViewRoot2.getViewId() : (String)facesContext.getAttributes().get("com.sun.faces.viewId");
            }
            this.partial = this.stateInfo.usePartialStateSaving(string);
            this.partialLocked = true;
        }
        return this.partial;
    }

    public boolean trackViewModifications() {
        return this.trackMods;
    }

    public void startTrackViewModifications(FacesContext facesContext, UIViewRoot uIViewRoot) {
        if (this.modListener == null) {
            if (uIViewRoot != null) {
                this.modListener = this.createAddRemoveListener(facesContext, uIViewRoot);
                uIViewRoot.subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)this.modListener);
                uIViewRoot.subscribeToViewEvent(PreRemoveFromViewEvent.class, (SystemEventListener)this.modListener);
            } else {
                LOGGER.warning("Unable to attach AddRemoveListener to UIViewRoot because it is null");
            }
        }
        this.setTrackViewModifications(true);
    }

    public void setTrackViewModifications(boolean bl) {
        this.trackMods = bl;
    }

    public boolean componentAddedDynamically(UIComponent uIComponent) {
        return uIComponent.getAttributes().containsKey("com.sun.faces.DynamicComponent");
    }

    public int getIndexOfDynamicallyAddedChildInParent(UIComponent uIComponent) {
        int n = -1;
        Map map = uIComponent.getAttributes();
        if (map.containsKey("com.sun.faces.DynamicComponent")) {
            n = (Integer)map.get("com.sun.faces.DynamicComponent");
        }
        return n;
    }

    public boolean hasOneOrMoreDynamicChild(UIComponent uIComponent) {
        return uIComponent.getAttributes().containsKey("com.sun.faces.DynamicChildCount");
    }

    private int incrementDynamicChildCount(FacesContext facesContext, UIComponent uIComponent) {
        int n;
        Map map = uIComponent.getAttributes();
        Integer n2 = (Integer)map.get("com.sun.faces.DynamicChildCount");
        if (null != n2) {
            Integer n3 = n2;
            Integer n4 = n2 = Integer.valueOf(n2 + 1);
            n = n3;
        } else {
            n = 1;
        }
        map.put("com.sun.faces.DynamicChildCount", n);
        facesContext.getViewRoot().getAttributes().put("com.sun.faces.TreeHasDynamicComponents", Boolean.TRUE);
        return n;
    }

    private int decrementDynamicChildCount(FacesContext facesContext, UIComponent uIComponent) {
        int n = 0;
        Map map = uIComponent.getAttributes();
        Integer n2 = (Integer)map.get("com.sun.faces.DynamicChildCount");
        if (null != n2) {
            int n3;
            if (0 < n2) {
                Integer n4 = n2;
                Integer n5 = n2 = Integer.valueOf(n2 - 1);
                n3 = n4;
            } else {
                n3 = n = 0;
            }
        }
        if (0 == n && null != n2) {
            map.remove("com.sun.faces.DynamicChildCount");
        }
        facesContext.getViewRoot().getAttributes().put("com.sun.faces.TreeHasDynamicComponents", Boolean.TRUE);
        return n;
    }

    public List<ComponentStruct> getDynamicActions() {
        return this.modListener != null ? this.modListener.getDynamicActions() : null;
    }

    public HashMap<String, UIComponent> getDynamicComponents() {
        return this.modListener != null ? this.modListener.getDynamicComponents() : null;
    }

    private AddRemoveListener createAddRemoveListener(FacesContext facesContext, UIViewRoot uIViewRoot) {
        return this.isPartialStateSaving(facesContext, uIViewRoot.getViewId()) ? new DynamicAddRemoveListener(facesContext) : new StatelessAddRemoveListener(facesContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DynamicAddRemoveListener
    extends AddRemoveListener {
        private List<ComponentStruct> dynamicActions;
        private transient HashMap<String, UIComponent> dynamicComponents;

        public DynamicAddRemoveListener(FacesContext facesContext) {
            super(facesContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ComponentStruct> getDynamicActions() {
            DynamicAddRemoveListener dynamicAddRemoveListener = this;
            synchronized (dynamicAddRemoveListener) {
                if (this.dynamicActions == null) {
                    this.dynamicActions = new ArrayList<ComponentStruct>();
                }
            }
            return this.dynamicActions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HashMap<String, UIComponent> getDynamicComponents() {
            DynamicAddRemoveListener dynamicAddRemoveListener = this;
            synchronized (dynamicAddRemoveListener) {
                if (this.dynamicComponents == null) {
                    this.dynamicComponents = new HashMap();
                }
            }
            return this.dynamicComponents;
        }

        @Override
        protected void handleRemove(FacesContext facesContext, UIComponent uIComponent) {
            if (uIComponent.isInView()) {
                StateContext.this.decrementDynamicChildCount(facesContext, uIComponent.getParent());
                ComponentStruct componentStruct = new ComponentStruct();
                componentStruct.action = "REMOVE";
                componentStruct.clientId = uIComponent.getClientId(facesContext);
                componentStruct.id = uIComponent.getId();
                this.handleAddRemoveWithAutoPrune(uIComponent, componentStruct);
            }
        }

        @Override
        protected void handleAdd(FacesContext facesContext, UIComponent uIComponent) {
            if (uIComponent.getParent() != null && uIComponent.getParent().isInView()) {
                String string;
                String string2 = uIComponent.getId();
                if (string2 != null) {
                    uIComponent.setId(string2);
                }
                if ((string = this.findFacetNameForComponent(uIComponent)) != null) {
                    StateContext.this.incrementDynamicChildCount(facesContext, uIComponent.getParent());
                    uIComponent.clearInitialState();
                    uIComponent.getAttributes().put("com.sun.faces.DynamicComponent", uIComponent.getParent().getChildren().indexOf(uIComponent));
                    ComponentStruct componentStruct = new ComponentStruct();
                    componentStruct.action = "ADD";
                    componentStruct.facetName = string;
                    componentStruct.parentClientId = uIComponent.getParent().getClientId(facesContext);
                    componentStruct.clientId = uIComponent.getClientId(facesContext);
                    componentStruct.id = uIComponent.getId();
                    this.handleAddRemoveWithAutoPrune(uIComponent, componentStruct);
                } else {
                    StateContext.this.incrementDynamicChildCount(facesContext, uIComponent.getParent());
                    uIComponent.clearInitialState();
                    uIComponent.getAttributes().put("com.sun.faces.DynamicComponent", uIComponent.getParent().getChildren().indexOf(uIComponent));
                    ComponentStruct componentStruct = new ComponentStruct();
                    componentStruct.action = "ADD";
                    componentStruct.parentClientId = uIComponent.getParent().getClientId(facesContext);
                    componentStruct.clientId = uIComponent.getClientId(facesContext);
                    componentStruct.id = uIComponent.getId();
                    this.handleAddRemoveWithAutoPrune(uIComponent, componentStruct);
                }
            }
        }

        private String findFacetNameForComponent(UIComponent uIComponent) {
            Set set = uIComponent.getParent().getFacets().entrySet();
            for (Map.Entry entry : set) {
                if (uIComponent != entry.getValue()) continue;
                return (String)entry.getKey();
            }
            return null;
        }

        private void handleAddRemoveWithAutoPrune(UIComponent uIComponent, ComponentStruct componentStruct) {
            List<ComponentStruct> list = this.getDynamicActions();
            HashMap<String, UIComponent> hashMap = this.getDynamicComponents();
            int n = list.indexOf(componentStruct);
            if (n == -1) {
                list.add(componentStruct);
                hashMap.put(componentStruct.clientId, uIComponent);
            } else {
                int n2 = list.lastIndexOf(componentStruct);
                if (n2 == n) {
                    ComponentStruct componentStruct2 = list.get(n);
                    if ("ADD".equals(componentStruct2.action)) {
                        if ("ADD".equals(componentStruct.action)) {
                            throw new FacesException("Cannot add the same component twice: " + componentStruct.clientId);
                        }
                        if ("REMOVE".equals(componentStruct.action)) {
                            list.remove(n);
                            hashMap.remove(componentStruct.clientId);
                        }
                    }
                    if ("REMOVE".equals(componentStruct2.action)) {
                        if ("ADD".equals(componentStruct.action)) {
                            list.add(componentStruct);
                            hashMap.put(componentStruct.clientId, uIComponent);
                        }
                        if ("REMOVE".equals(componentStruct.action)) {
                            throw new FacesException("Cannot remove the same component twice: " + componentStruct.clientId);
                        }
                    }
                } else {
                    if ("ADD".equals(componentStruct.action)) {
                        throw new FacesException("Cannot add the same component twice: " + componentStruct.clientId);
                    }
                    if ("REMOVE".equals(componentStruct.action)) {
                        list.remove(n2);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StatelessAddRemoveListener
    extends NoopAddRemoveListener {
        private static final String DYNAMIC_COMPONENT_ADD_COLLECTION = "com.sun.faces.DynamicComponentSubtreeRoots";

        public StatelessAddRemoveListener(FacesContext facesContext) {
            super(facesContext);
        }

        private boolean thisEventCorrespondsToSubtreeRootRemove(FacesContext facesContext, UIComponent uIComponent) {
            boolean bl = false;
            if (null != uIComponent && null != (uIComponent = uIComponent.getParent())) {
                bl = uIComponent.isInView();
            }
            return bl;
        }

        private boolean thisEventCorrespondsToSubtreeRootAdd(FacesContext facesContext, UIComponent uIComponent) {
            boolean bl = false;
            Map map = facesContext.getAttributes();
            UIViewRoot uIViewRoot = facesContext.getViewRoot();
            UIComponent uIComponent2 = uIComponent;
            if (null != uIComponent) {
                Collection<UIComponent> collection = this.getDynamicComponentCollection(map);
                if (collection.contains(uIComponent)) {
                    bl = true;
                } else {
                    for (uIComponent = uIComponent.getParent(); null != uIComponent && !collection.contains(uIComponent); uIComponent = uIComponent.getParent()) {
                    }
                    if (null == uIComponent || uIViewRoot.equals(uIComponent)) {
                        collection.add(uIComponent2);
                        bl = true;
                    }
                }
            }
            return bl;
        }

        private Collection<UIComponent> getDynamicComponentCollection(Map<Object, Object> map) {
            HashSet hashSet = (HashSet)map.get(DYNAMIC_COMPONENT_ADD_COLLECTION);
            if (null == hashSet) {
                hashSet = new HashSet();
                map.put(DYNAMIC_COMPONENT_ADD_COLLECTION, hashSet);
            }
            return hashSet;
        }

        @Override
        protected void handleRemove(FacesContext facesContext, UIComponent uIComponent) {
            if (!this.thisEventCorrespondsToSubtreeRootRemove(facesContext, uIComponent)) {
                return;
            }
            Map map = uIComponent.getAttributes();
            String string = (String)map.remove("com.sun.faces.facelets.MARK_ID");
            if (string != null) {
                map.put(MARK_CREATED_REMOVED, string);
                this.childRemovedFromParent(uIComponent.getParent(), string);
            }
        }

        private void childRemovedFromParent(UIComponent uIComponent, String string) {
            if (uIComponent != null) {
                Collection<String> collection = this.getPreviouslyRemovedChildren(uIComponent);
                collection.add(string);
                this.markChildrenModified(uIComponent);
            }
        }

        private Collection<String> getPreviouslyRemovedChildren(UIComponent uIComponent) {
            Map map = uIComponent.getAttributes();
            MostlySingletonSet mostlySingletonSet = (MostlySingletonSet)map.get("com.sun.faces.facelets.REMOVED_CHILDREN");
            if (mostlySingletonSet == null) {
                mostlySingletonSet = new MostlySingletonSet();
                map.put("com.sun.faces.facelets.REMOVED_CHILDREN", mostlySingletonSet);
            }
            return mostlySingletonSet;
        }

        private void markChildrenModified(UIComponent uIComponent) {
            uIComponent.getAttributes().put("com.sun.faces.facelets.MARK_CHILDREN_MODIFIED", true);
        }

        @Override
        protected void handleAdd(FacesContext facesContext, UIComponent uIComponent) {
            if (!this.thisEventCorrespondsToSubtreeRootAdd(facesContext, uIComponent)) {
                return;
            }
            Map map = uIComponent.getAttributes();
            String string = (String)map.get(MARK_CREATED_REMOVED);
            if (this.childAddedToSameParentAsBefore(uIComponent.getParent(), string)) {
                map.remove(MARK_CREATED_REMOVED);
                map.put("com.sun.faces.facelets.MARK_ID", string);
            }
            this.markChildrenModified(uIComponent.getParent());
        }

        private boolean childAddedToSameParentAsBefore(UIComponent uIComponent, String string) {
            Map map;
            Collection collection;
            if (uIComponent != null && (collection = (Collection)(map = uIComponent.getAttributes()).get("com.sun.faces.facelets.REMOVED_CHILDREN")) != null && collection.remove(string)) {
                if (collection.isEmpty()) {
                    map.remove("com.sun.faces.facelets.REMOVED_CHILDREN");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NoopAddRemoveListener
    extends AddRemoveListener {
        private HashMap emptyComponentsMap;

        public NoopAddRemoveListener(FacesContext facesContext) {
            super(facesContext);
            this.emptyComponentsMap = new HashMap();
        }

        @Override
        public List<ComponentStruct> getDynamicActions() {
            return Collections.emptyList();
        }

        @Override
        public HashMap<String, UIComponent> getDynamicComponents() {
            return this.emptyComponentsMap;
        }

        @Override
        protected void handleRemove(FacesContext facesContext, UIComponent uIComponent) {
        }

        @Override
        protected void handleAdd(FacesContext facesContext, UIComponent uIComponent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AddRemoveListener
    implements SystemEventListener {
        private StateContext stateCtx;

        protected AddRemoveListener(FacesContext facesContext) {
            this.stateCtx = StateContext.getStateContext(facesContext);
        }

        public abstract List<ComponentStruct> getDynamicActions();

        public abstract HashMap<String, UIComponent> getDynamicComponents();

        public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (systemEvent instanceof PreRemoveFromViewEvent) {
                if (this.stateCtx.trackViewModifications()) {
                    this.handleRemove(facesContext, ((PreRemoveFromViewEvent)systemEvent).getComponent());
                    facesContext.getViewRoot().getAttributes().put("com.sun.faces.TreeHasDynamicComponents", Boolean.TRUE);
                }
            } else if (this.stateCtx.trackViewModifications()) {
                this.handleAdd(facesContext, ((PostAddToViewEvent)systemEvent).getComponent());
                facesContext.getViewRoot().getAttributes().put("com.sun.faces.TreeHasDynamicComponents", Boolean.TRUE);
            }
        }

        public boolean isListenerForSource(Object object) {
            return object instanceof UIComponent && !(object instanceof UIViewRoot);
        }

        protected abstract void handleRemove(FacesContext var1, UIComponent var2);

        protected abstract void handleAdd(FacesContext var1, UIComponent var2);
    }
}

