/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.TagLibraryImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagLibrary;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletTaglibConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIBRARY_CLASS = "library-class";
    private static final String TAGLIB_NAMESPACE = "namespace";
    private static final String TAG = "tag";
    private static final String FUNCTION = "function";
    private static final String TAG_NAME = "tag-name";
    private static final String COMPONENT = "component";
    private static final String VALIDATOR = "validator";
    private static final String CONVERTER = "converter";
    private static final String BEHAVIOR = "behavior";
    private static final String SOURCE = "source";
    private static final String RESOURCE_ID = "resource-id";
    private static final String HANDLER_CLASS = "handler-class";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String CONVERTER_ID = "converter-id";
    private static final String BEHAVIOR_ID = "behavior-id";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String FUNCTION_NAME = "function-name";
    private static final String FUNCTION_CLASS = "function-class";
    private static final String FUNCTION_SIGNATURE = "function-signature";
    private static final String COMPOSITE_LIBRARY_NAME = "composite-library-name";

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        assert (applicationAssociate != null);
        Compiler compiler = applicationAssociate.getCompiler();
        int n = documentInfoArray.length;
        for (int i = 0; i < n; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing facelet-taglibrary document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS(string, LIBRARY_CLASS);
            if (nodeList != null && nodeList.getLength() > 0) {
                this.processTaglibraryClass(servletContext, nodeList, compiler);
                continue;
            }
            this.processTagLibrary(servletContext, element, string, compiler);
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void processTaglibraryClass(ServletContext servletContext, NodeList nodeList, Compiler compiler) {
        Node node = nodeList.item(0);
        String string = this.getNodeText(node);
        TagLibrary tagLibrary = (TagLibrary)this.createInstance(servletContext, string, node);
        compiler.addTagLibrary(tagLibrary);
    }

    private void processTagLibrary(ServletContext servletContext, Element element, String string, Compiler compiler) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            TagLibraryImpl tagLibraryImpl;
            Object object;
            String string2 = null;
            String string3 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                object = nodeList.item(i);
                if (TAGLIB_NAMESPACE.equals(object.getLocalName())) {
                    string2 = this.getNodeText((Node)object);
                    continue;
                }
                if (!COMPOSITE_LIBRARY_NAME.equals(object.getLocalName())) continue;
                string3 = this.getNodeText((Node)object);
            }
            if (string3 != null) {
                tagLibraryImpl = new CompositeComponentTagLibrary(string2, string3);
                compiler.addTagLibrary(tagLibraryImpl);
            } else {
                tagLibraryImpl = new TagLibraryImpl(string2);
            }
            NodeList nodeList2 = element.getElementsByTagNameNS(string, TAG);
            this.processTags(servletContext, element, nodeList2, tagLibraryImpl);
            object = element.getElementsByTagNameNS(string, FUNCTION);
            this.processFunctions(servletContext, (NodeList)object, tagLibraryImpl);
            compiler.addTagLibrary(tagLibraryImpl);
        }
    }

    private void processTags(ServletContext servletContext, Element element, NodeList nodeList, TagLibraryImpl tagLibraryImpl) {
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                String string = null;
                NodeList nodeList3 = null;
                NodeList nodeList4 = null;
                NodeList nodeList5 = null;
                NodeList nodeList6 = null;
                Node node2 = null;
                Node node3 = null;
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node4 = nodeList2.item(j);
                    if (TAG_NAME.equals(node4.getLocalName())) {
                        string = this.getNodeText(node4);
                        continue;
                    }
                    if (COMPONENT.equals(node4.getLocalName())) {
                        nodeList3 = node4.getChildNodes();
                        continue;
                    }
                    if (CONVERTER.equals(node4.getLocalName())) {
                        nodeList4 = node4.getChildNodes();
                        continue;
                    }
                    if (VALIDATOR.equals(node4.getLocalName())) {
                        nodeList5 = node4.getChildNodes();
                        continue;
                    }
                    if (BEHAVIOR.equals(node4.getLocalName())) {
                        nodeList6 = node4.getChildNodes();
                        continue;
                    }
                    if (SOURCE.equals(node4.getLocalName())) {
                        node2 = node4;
                        continue;
                    }
                    if (!HANDLER_CLASS.equals(node4.getLocalName())) continue;
                    node3 = node4;
                }
                if (nodeList3 != null) {
                    this.processComponent(servletContext, element, nodeList3, tagLibraryImpl, string);
                    continue;
                }
                if (nodeList4 != null) {
                    this.processConverter(servletContext, nodeList4, tagLibraryImpl, string);
                    continue;
                }
                if (nodeList5 != null) {
                    this.processValidator(servletContext, nodeList5, tagLibraryImpl, string);
                    continue;
                }
                if (nodeList6 != null) {
                    this.processBehavior(servletContext, nodeList6, tagLibraryImpl, string);
                    continue;
                }
                if (node2 != null) {
                    this.processSource(element, node2, tagLibraryImpl, string);
                    continue;
                }
                if (node3 == null) continue;
                this.processHandlerClass(servletContext, node3, tagLibraryImpl, string);
            }
        }
    }

    private void processBehavior(ServletContext servletContext, NodeList nodeList, TagLibraryImpl tagLibraryImpl, String string) {
        if (nodeList != null && nodeList.getLength() > 0) {
            String string2 = null;
            String string3 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (BEHAVIOR_ID.equals(node.getLocalName())) {
                    string2 = this.getNodeText(node);
                    continue;
                }
                if (!HANDLER_CLASS.equals(node.getLocalName())) continue;
                string3 = this.getNodeText(node);
            }
            if (string3 != null) {
                try {
                    Class<?> clazz = this.loadClass(servletContext, string3, this, null);
                    tagLibraryImpl.putBehavior(string, string2, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ConfigurationException(classNotFoundException);
                }
            } else {
                tagLibraryImpl.putBehavior(string, string2);
            }
        }
    }

    private void processHandlerClass(ServletContext servletContext, Node node, TagLibraryImpl tagLibraryImpl, String string) {
        block7: {
            String string2 = this.getNodeText(node);
            if (string2 == null) {
                throw new ConfigurationException("The tag named " + string + " from namespace " + tagLibraryImpl.getNamespace() + " has a null handler-class defined");
            }
            try {
                try {
                    Class<?> clazz = this.loadClass(servletContext, string2, this, null);
                    tagLibraryImpl.putTagHandler(string, clazz);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    String string3 = noClassDefFoundError.toString();
                    if (string3.contains("com/sun/facelets/") || string3.contains("com.sun.facelets.")) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{node});
                        }
                        break block7;
                    }
                    throw noClassDefFoundError;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(classNotFoundException);
            }
        }
    }

    private void processSource(Element element, Node node, TagLibraryImpl tagLibraryImpl, String string) {
        String string2 = element.getOwnerDocument().getDocumentURI();
        String string3 = this.getNodeText(node);
        try {
            URL uRL = new URL(new URL(string2), string3);
            tagLibraryImpl.putUserTag(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FacesException((Throwable)malformedURLException);
        }
    }

    private void processResourceId(Element element, Node node, TagLibraryImpl tagLibraryImpl, String string) {
        String string2 = this.getNodeText(node);
        tagLibraryImpl.putCompositeComponentTag(string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processValidator(ServletContext servletContext, NodeList nodeList, TagLibraryImpl tagLibraryImpl, String string) {
        if (nodeList == null || nodeList.getLength() <= 0) return;
        String string2 = null;
        String string3 = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (VALIDATOR_ID.equals(node.getLocalName())) {
                string2 = this.getNodeText(node);
                continue;
            }
            if (!HANDLER_CLASS.equals(node.getLocalName())) continue;
            string3 = this.getNodeText(node);
        }
        if (string3 != null) {
            try {
                Class<?> clazz = this.loadClass(servletContext, string3, this, null);
                tagLibraryImpl.putValidator(string, string2, clazz);
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string4 = noClassDefFoundError.toString();
                if (!string4.contains("com/sun/facelets/") && !string4.contains("com.sun.facelets.")) throw noClassDefFoundError;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{string3});
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(classNotFoundException);
            }
        } else {
            tagLibraryImpl.putValidator(string, string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConverter(ServletContext servletContext, NodeList nodeList, TagLibraryImpl tagLibraryImpl, String string) {
        if (nodeList == null || nodeList.getLength() <= 0) return;
        String string2 = null;
        String string3 = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (CONVERTER_ID.equals(node.getLocalName())) {
                string2 = this.getNodeText(node);
                continue;
            }
            if (!HANDLER_CLASS.equals(node.getLocalName())) continue;
            string3 = this.getNodeText(node);
        }
        if (string3 != null) {
            try {
                Class<?> clazz = this.loadClass(servletContext, string3, this, null);
                tagLibraryImpl.putConverter(string, string2, clazz);
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string4 = noClassDefFoundError.toString();
                if (!string4.contains("com/sun/facelets/") && !string4.contains("com.sun.facelets.")) throw noClassDefFoundError;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{string3});
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(classNotFoundException);
            }
        } else {
            tagLibraryImpl.putConverter(string, string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComponent(ServletContext servletContext, Element element, NodeList nodeList, TagLibraryImpl tagLibraryImpl, String string) {
        if (nodeList == null || nodeList.getLength() <= 0) return;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Node node = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (COMPONENT_TYPE.equals(node2.getLocalName())) {
                string2 = this.getNodeText(node2);
                continue;
            }
            if (RENDERER_TYPE.equals(node2.getLocalName())) {
                string3 = this.getNodeText(node2);
                continue;
            }
            if (HANDLER_CLASS.equals(node2.getLocalName())) {
                string4 = this.getNodeText(node2);
                continue;
            }
            if (!RESOURCE_ID.equals(node2.getLocalName())) continue;
            node = node2;
        }
        if (string4 != null) {
            try {
                Class<?> clazz = this.loadClass(servletContext, string4, this, null);
                tagLibraryImpl.putComponent(string, string2, string3, clazz);
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string5 = noClassDefFoundError.toString();
                if (!string5.contains("com/sun/facelets/") && !string5.contains("com.sun.facelets.")) throw noClassDefFoundError;
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "jsf.config.legacy.facelet.warning", new Object[]{string4});
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(classNotFoundException);
            }
        } else if (node != null) {
            this.processResourceId(element, node, tagLibraryImpl, string);
            return;
        } else {
            tagLibraryImpl.putComponent(string, string2, string3);
        }
    }

    private void processFunctions(ServletContext servletContext, NodeList nodeList, TagLibraryImpl tagLibraryImpl) {
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                String string = null;
                String string2 = null;
                String string3 = null;
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node = nodeList2.item(j);
                    if (FUNCTION_NAME.equals(node.getLocalName())) {
                        string = this.getNodeText(node);
                        continue;
                    }
                    if (FUNCTION_CLASS.equals(node.getLocalName())) {
                        string2 = this.getNodeText(node);
                        continue;
                    }
                    if (!FUNCTION_SIGNATURE.equals(node.getLocalName())) continue;
                    string3 = this.getNodeText(node);
                }
                try {
                    Class<?> clazz = this.loadClass(servletContext, string2, this, null);
                    Method method = FaceletTaglibConfigProcessor.createMethod(clazz, string3);
                    tagLibraryImpl.putFunction(string, method);
                    continue;
                }
                catch (Exception exception) {
                    throw new ConfigurationException(exception);
                }
            }
        }
    }

    private static Method createMethod(Class clazz, String string) throws Exception {
        Class[] classArray;
        String string2 = string.replaceAll("\\s+", " ");
        int n = string2.indexOf(32);
        if (n == -1) {
            throw new Exception("Must Provide Return Type: " + string2);
        }
        int n2 = string2.indexOf(40, n + 1);
        if (n2 == -1) {
            throw new Exception("Must provide a method name, followed by '(': " + string2);
        }
        String string3 = string2.substring(n + 1, n2).trim();
        n = string2.indexOf(41, n2 + 1);
        if (n == -1) {
            throw new Exception("Must close parentheses, ')' missing: " + string2);
        }
        String[] stringArray = string2.substring(n2 + 1, n).trim().split(",");
        if (stringArray.length == 1 && "".equals(stringArray[0])) {
            classArray = new Class[]{};
        } else {
            classArray = new Class[stringArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = ReflectionUtil.forName(stringArray[i].trim());
            }
        }
        try {
            return clazz.getMethod(string3, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Exception("No Function Found on type: " + clazz.getName() + " with signature: " + string2);
        }
    }
}

