/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationInstanceFactoryMetadataMap;
import com.sun.faces.application.annotation.AnnotationManager;
import com.sun.faces.config.ConfigManager;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.scripting.groovy.ActionListenerProxy;
import com.sun.faces.scripting.groovy.ELResolverProxy;
import com.sun.faces.scripting.groovy.NavigationHandlerProxy;
import com.sun.faces.scripting.groovy.PhaseListenerProxy;
import com.sun.faces.scripting.groovy.RendererProxy;
import com.sun.faces.scripting.groovy.ViewHandlerProxy;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigProcessor
implements ConfigProcessor {
    private ConfigProcessor nextProcessor;
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String CLASS_METADATA_MAP_KEY_SUFFIX = ".METADATA";

    private ApplicationInstanceFactoryMetadataMap<String, Object> getClassMetadataMap(ServletContext servletContext) {
        ApplicationInstanceFactoryMetadataMap applicationInstanceFactoryMetadataMap = (ApplicationInstanceFactoryMetadataMap)servletContext.getAttribute(this.getClassMetadataMapKey());
        if (null == applicationInstanceFactoryMetadataMap) {
            applicationInstanceFactoryMetadataMap = new ApplicationInstanceFactoryMetadataMap((Map<String, Object>)new ConcurrentHashMap<String, Object>());
            servletContext.setAttribute(this.getClassMetadataMapKey(), applicationInstanceFactoryMetadataMap);
        }
        return applicationInstanceFactoryMetadataMap;
    }

    @Override
    public void initializeClassMetadataMap(ServletContext servletContext) {
        this.getClassMetadataMap(servletContext);
    }

    protected String getClassMetadataMapKey() {
        return this.getClass().getName() + CLASS_METADATA_MAP_KEY_SUFFIX;
    }

    @Override
    public void setNext(ConfigProcessor configProcessor) {
        this.nextProcessor = configProcessor;
    }

    @Override
    public ConfigProcessor getNext() {
        return this.nextProcessor;
    }

    @Override
    public void invokeNext(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        if (this.nextProcessor != null) {
            this.nextProcessor.process(servletContext, documentInfoArray);
        }
    }

    @Override
    public void destroyNext(ServletContext servletContext) {
        if (this.nextProcessor != null) {
            this.nextProcessor.destroy(servletContext);
        }
    }

    @Override
    public void destroy(ServletContext servletContext) {
        this.destroyNext(servletContext);
    }

    protected Application getApplication() {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return applicationFactory.getApplication();
    }

    protected String getNodeText(Node node) {
        String string = null;
        if (node != null && (string = node.getTextContent()) != null) {
            string = string.trim();
        }
        return string != null && string.length() != 0 ? string : null;
    }

    protected Map<String, String> getTextMap(List<Node> list) {
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            HashMap<String, String> hashMap = new HashMap<String, String>(n, 1.0f);
            for (int i = 0; i < n; ++i) {
                Node node = list.get(i);
                String string = this.getNodeText(node);
                if (string == null) continue;
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    String string2 = this.getNodeText(namedNodeMap.getNamedItem("lang"));
                    if (string2 == null) {
                        string2 = this.getNodeText(namedNodeMap.getNamedItem("xml:lang"));
                    }
                    if (string2 != null) {
                        hashMap.put(string2, string);
                        continue;
                    }
                    hashMap.put("DEFAULT", string);
                    continue;
                }
                hashMap.put("DEFAULT", string);
            }
            return hashMap;
        }
        return null;
    }

    protected Class<?> findRootType(ServletContext servletContext, String string, Node node, Class<?>[] classArray) {
        try {
            Class<?> clazz = this.loadClass(servletContext, string, this, null);
            for (Class<?> clazz2 : classArray) {
                if (ReflectionUtils.lookupConstructor(clazz, clazz2) == null) continue;
                return clazz2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", string), node), classNotFoundException);
        }
        return null;
    }

    protected Object createInstance(ServletContext servletContext, String string, Node node) {
        return this.createInstance(servletContext, string, null, null, node);
    }

    protected Object createInstance(ServletContext servletContext, String string, Class clazz, Object object, Node node) {
        boolean[] blArray = new boolean[]{false};
        Object object2 = this.createInstance(servletContext, string, clazz, object, node, true, blArray);
        return object2;
    }

    protected Object createInstance(ServletContext servletContext, String string, Class clazz, Object object, Node node, boolean bl, boolean[] blArray) {
        Object object2;
        block14: {
            object2 = null;
            if (string != null) {
                try {
                    Object object3;
                    Class<?> clazz2 = this.loadClass(servletContext, string, object2, null);
                    if (clazz2 == null) break block14;
                    if (this.isDevModeEnabled(servletContext) && (object3 = clazz2.getInterfaces()) != null) {
                        for (Class<?> clazz3 : object3) {
                            if (!"groovy.lang.GroovyObject".equals(clazz3.getName())) continue;
                            object2 = this.createScriptProxy(clazz, string, object);
                            break;
                        }
                    }
                    if (object2 == null && clazz != null && object != null && (object3 = ReflectionUtils.lookupConstructor(clazz2, clazz)) != null) {
                        object2 = ((Constructor)object3).newInstance(object);
                    }
                    if (clazz2 != null && object2 == null) {
                        object2 = clazz2.newInstance();
                    }
                    if (!((ApplicationInstanceFactoryMetadataMap)(object3 = this.getClassMetadataMap(servletContext))).hasAnnotations(string) || !bl) break block14;
                    InjectionProvider injectionProvider = (InjectionProvider)FacesContext.getCurrentInstance().getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY);
                    try {
                        injectionProvider.inject(object2);
                    }
                    catch (InjectionProviderException injectionProviderException) {
                        LOGGER.log(Level.SEVERE, "Unable to inject instance" + string, injectionProviderException);
                        throw new FacesException((Throwable)injectionProviderException);
                    }
                    try {
                        injectionProvider.invokePostConstruct(object2);
                    }
                    catch (InjectionProviderException injectionProviderException) {
                        LOGGER.log(Level.SEVERE, "Unable to invoke @PostConstruct annotated method on instance " + string, injectionProviderException);
                        throw new FacesException((Throwable)injectionProviderException);
                    }
                    blArray[0] = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to find class ''{0}''", string), node), classNotFoundException);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is missing a runtime dependency: {1}", string, noClassDefFoundError.toString()), node), noClassDefFoundError);
                }
                catch (ClassCastException classCastException) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Class ''{0}'' is not an instance of ''{1}''", string, clazz), node), classCastException);
                }
                catch (Exception exception) {
                    throw new ConfigurationException(this.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", string, exception.toString()), node), exception);
                }
            }
        }
        return object2;
    }

    protected void destroyInstance(ServletContext servletContext, String string, Object object) {
        InjectionProvider injectionProvider;
        ApplicationInstanceFactoryMetadataMap<String, Object> applicationInstanceFactoryMetadataMap;
        if (null != object && (applicationInstanceFactoryMetadataMap = this.getClassMetadataMap(servletContext)).hasAnnotations(string) && null != (injectionProvider = (InjectionProvider)FacesContext.getCurrentInstance().getAttributes().get(ConfigManager.INJECTION_PROVIDER_KEY))) {
            try {
                injectionProvider.invokePreDestroy(object);
            }
            catch (InjectionProviderException injectionProviderException) {
                LOGGER.log(Level.SEVERE, "Unable to invoke @PreDestroy annotated method on instance " + string, injectionProviderException);
                throw new FacesException((Throwable)injectionProviderException);
            }
        }
    }

    protected Class<?> loadClass(ServletContext servletContext, String string, Object object, Class<?> clazz) throws ClassNotFoundException {
        ApplicationInstanceFactoryMetadataMap<String, Object> applicationInstanceFactoryMetadataMap = this.getClassMetadataMap(servletContext);
        Class clazz2 = (Class)applicationInstanceFactoryMetadataMap.get(string);
        if (null == clazz2) {
            try {
                clazz2 = Util.loadClass(string, object);
                if (!this.isDevModeEnabled(servletContext)) {
                    applicationInstanceFactoryMetadataMap.put(string, clazz2);
                } else {
                    applicationInstanceFactoryMetadataMap.scanForAnnotations(string, clazz2);
                }
                assert (clazz2 != null);
            }
            catch (Exception exception) {
                throw new FacesException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
            throw new ClassCastException();
        }
        return clazz2;
    }

    protected void processAnnotations(Class<? extends Annotation> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(facesContext.getExternalContext());
        AnnotationManager annotationManager = applicationAssociate.getAnnotationManager();
        annotationManager.applyConfigAnnotations(facesContext, clazz, ConfigManager.getAnnotatedClasses(facesContext).get(clazz));
    }

    private String buildMessage(String string, Node node) {
        return MessageFormat.format("\n  Source Document: {0}\n  Cause: {1}", node.getOwnerDocument().getDocumentURI(), string);
    }

    private Object createScriptProxy(Class<?> clazz, String string, Object object) {
        if (Renderer.class.equals(clazz)) {
            return new RendererProxy(string);
        }
        if (PhaseListener.class.equals(clazz)) {
            return new PhaseListenerProxy(string);
        }
        if (ViewHandler.class.equals(clazz)) {
            return new ViewHandlerProxy(string, (ViewHandler)object);
        }
        if (NavigationHandler.class.equals(clazz)) {
            return new NavigationHandlerProxy(string, (NavigationHandler)object);
        }
        if (ActionListener.class.equals(clazz)) {
            return new ActionListenerProxy(string, (ActionListener)object);
        }
        if (ELResolver.class.equals(clazz)) {
            return new ELResolverProxy(string);
        }
        return null;
    }

    private boolean isDevModeEnabled(ServletContext servletContext) {
        return this.getProjectStage(servletContext).equals((Object)ProjectStage.Development);
    }

    private ProjectStage getProjectStage(ServletContext servletContext) {
        ProjectStage projectStage = null;
        String string = AbstractConfigProcessor.class.getName() + ".PROJECTSTAGE";
        projectStage = (ProjectStage)servletContext.getAttribute(string);
        if (projectStage == null) {
            block9: {
                WebConfiguration webConfiguration = WebConfiguration.getInstance(FacesContext.getCurrentInstance().getExternalContext());
                String string2 = webConfiguration.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ProjectStage);
                if (string2 != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "ProjectStage configured via JNDI: {0}", string2);
                    }
                } else {
                    string2 = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.JavaxFacesProjectStage);
                    if (string2 != null && LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "ProjectStage configured via servlet context init parameter: {0}", string2);
                    }
                }
                if (string2 != null) {
                    try {
                        projectStage = ProjectStage.valueOf((String)string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!LOGGER.isLoggable(Level.INFO)) break block9;
                        LOGGER.log(Level.INFO, "Unable to discern ProjectStage for value {0}.", string2);
                    }
                }
            }
            if (projectStage == null) {
                projectStage = ProjectStage.Production;
            }
            servletContext.setAttribute(string, (Object)projectStage);
        }
        return projectStage;
    }
}

