/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.OnOffResponseWrapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.ViewDeclarationLanguage;

public class RenderResponsePhase
extends Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    public void execute(FacesContext facesContext) throws FacesException {
        PartialViewContext partialViewContext;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RenderResponsePhase");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to render view " + facesContext.getViewRoot().getViewId());
        }
        if ((partialViewContext = facesContext.getPartialViewContext()).isAjaxRequest()) {
            OnOffResponseWrapper onOffResponse = new OnOffResponseWrapper(facesContext);
            onOffResponse.setEnabled(false);
        }
        try {
            boolean viewIdsUnchanged;
            ViewHandler vh = facesContext.getApplication().getViewHandler();
            ViewDeclarationLanguage vdl = vh.getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId());
            if (vdl != null) {
                vdl.buildView(facesContext, facesContext.getViewRoot());
            }
            do {
                String beforePublishViewId = facesContext.getViewRoot().getViewId();
                facesContext.getApplication().publishEvent(facesContext, PreRenderViewEvent.class, (Object)facesContext.getViewRoot());
                String afterPublishViewId = facesContext.getViewRoot().getViewId();
                boolean bl = viewIdsUnchanged = beforePublishViewId == null && afterPublishViewId == null || beforePublishViewId != null && afterPublishViewId != null && beforePublishViewId.equals(afterPublishViewId);
                if (!facesContext.getResponseComplete()) continue;
                return;
            } while (!viewIdsUnchanged);
            vh.renderView(facesContext, facesContext.getViewRoot());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "+=+=+=+=+=+= View structure printout for " + facesContext.getViewRoot().getViewId());
            DebugUtil.printTree((UIComponent)facesContext.getViewRoot(), LOGGER, Level.FINEST);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RenderResponsePhase");
        }
    }

    public PhaseId getId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

