/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigureListener;
import com.sun.faces.util.FacesLogger;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.Renderer;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.webapp.FacesServlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesTypes(value={ManagedBean.class, FacesComponent.class, FacesValidator.class, FacesConverter.class, FacesBehaviorRenderer.class, ResourceDependency.class, ResourceDependencies.class, ListenerFor.class, ListenersFor.class, UIComponent.class, Validator.class, Converter.class, Renderer.class})
public class FacesInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACES_SERVLET_CLASS = FacesServlet.class.getName();

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        if (this.shouldCheckMappings(classes, servletContext)) {
            Map existing = servletContext.getServletRegistrations();
            for (ServletRegistration registration : existing.values()) {
                if (!FACES_SERVLET_CLASS.equals(registration.getClassName())) continue;
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Registering FacesServlet with mappings '/faces/*', '*.jsf', and '*.faces'.");
            }
            ServletRegistration.Dynamic reg = servletContext.addServlet("FacesServlet", "javax.faces.webapp.FacesServlet");
            reg.addMapping(new String[]{"/faces/*", "*.jsf", "*.faces"});
            servletContext.setAttribute("com.sun.faces.facesInitializerMappingsAdded", (Object)Boolean.TRUE);
            servletContext.addListener(ConfigureListener.class);
        }
    }

    private boolean shouldCheckMappings(Set<Class<?>> classes, ServletContext context) {
        if (classes != null && !classes.isEmpty()) {
            return true;
        }
        Enumeration parameters = context.getInitParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = ((String)parameters.nextElement()).trim();
            if (!paramName.startsWith("javax.faces.") && !paramName.startsWith("com.sun.faces.")) continue;
            return true;
        }
        try {
            return context.getResource("/WEB-INF/faces-config.xml") != null;
        }
        catch (MalformedURLException mue) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, mue.toString(), mue);
            }
            return false;
        }
    }
}

