/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DoubleRangeValidator
implements Validator,
PartialStateHolder {
    public static final String VALIDATOR_ID = "javax.faces.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";
    private Double maximum;
    private Double minimum;
    private boolean transientValue = false;
    private boolean initialState;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double d) {
        this.setMaximum(d);
    }

    public DoubleRangeValidator(double d, double d2) {
        this.setMaximum(d);
        this.setMinimum(d2);
    }

    public double getMaximum() {
        return this.maximum != null ? this.maximum : Double.MAX_VALUE;
    }

    public void setMaximum(double d) {
        this.clearInitialState();
        this.maximum = d;
    }

    public double getMinimum() {
        return this.minimum != null ? this.minimum : Double.MIN_VALUE;
    }

    public void setMinimum(double d) {
        this.clearInitialState();
        this.minimum = d;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            try {
                double d = DoubleRangeValidator.doubleValue(object);
                if (this.isMaximumSet() && d > this.maximum) {
                    if (this.isMinimumSet()) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, DoubleRangeValidator.stringValue(uIComponent, this.minimum, facesContext), DoubleRangeValidator.stringValue(uIComponent, this.maximum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MAXIMUM_MESSAGE_ID, DoubleRangeValidator.stringValue(uIComponent, this.maximum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                }
                if (this.isMinimumSet() && d < this.minimum) {
                    if (this.isMaximumSet()) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, DoubleRangeValidator.stringValue(uIComponent, this.minimum, facesContext), DoubleRangeValidator.stringValue(uIComponent, this.maximum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MINIMUM_MESSAGE_ID, DoubleRangeValidator.stringValue(uIComponent, this.minimum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, TYPE_MESSAGE_ID, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)numberFormatException);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleRangeValidator)) {
            return false;
        }
        DoubleRangeValidator doubleRangeValidator = (DoubleRangeValidator)object;
        return this.getMaximum() == doubleRangeValidator.getMaximum() && this.getMinimum() == doubleRangeValidator.getMinimum() && this.isMaximumSet() == doubleRangeValidator.isMaximumSet() && this.isMinimumSet() == doubleRangeValidator.isMinimumSet();
    }

    public int hashCode() {
        int n = Double.valueOf(this.getMinimum()).hashCode() + Double.valueOf(this.getMaximum()).hashCode() + Boolean.valueOf(this.isMinimumSet()).hashCode() + Boolean.valueOf(this.isMaximumSet()).hashCode();
        return n;
    }

    private static double doubleValue(Object object) throws NumberFormatException {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.parseDouble(object.toString());
    }

    private static String stringValue(UIComponent uIComponent, Double d, FacesContext facesContext) {
        Converter converter = facesContext.getApplication().createConverter("javax.faces.Number");
        return converter.getAsString(facesContext, uIComponent, d);
    }

    private boolean isMaximumSet() {
        return this.maximum != null;
    }

    private boolean isMinimumSet() {
        return this.minimum != null;
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] objectArray = new Object[]{this.maximum, this.minimum};
            return objectArray;
        }
        return null;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            Object[] objectArray = (Object[])object;
            this.maximum = (Double)objectArray[0];
            this.minimum = (Double)objectArray[1];
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }
}

