/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.event;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class MethodExpressionActionListener
implements ActionListener,
StateHolder {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.event", "javax.faces.LogStrings");
    private MethodExpression methodExpressionOneArg = null;
    private MethodExpression methodExpressionZeroArg = null;
    private boolean isTransient;
    private static final Class[] ACTION_LISTENER_ZEROARG_SIG = new Class[0];

    public MethodExpressionActionListener() {
    }

    public MethodExpressionActionListener(MethodExpression methodExpression) {
        this.methodExpressionOneArg = methodExpression;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext eLContext = facesContext.getELContext();
        this.methodExpressionZeroArg = facesContext.getApplication().getExpressionFactory().createMethodExpression(eLContext, methodExpression.getExpressionString(), Void.class, ACTION_LISTENER_ZEROARG_SIG);
    }

    public MethodExpressionActionListener(MethodExpression methodExpression, MethodExpression methodExpression2) {
        this.methodExpressionOneArg = methodExpression;
        this.methodExpressionZeroArg = methodExpression2;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        Throwable throwable = null;
        ELException eLException = null;
        if (actionEvent == null) {
            throw new NullPointerException();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext eLContext = facesContext.getELContext();
        try {
            this.methodExpressionOneArg.invoke(eLContext, new Object[]{actionEvent});
        }
        catch (MethodNotFoundException methodNotFoundException) {
            if (null != this.methodExpressionZeroArg) {
                try {
                    this.methodExpressionZeroArg.invoke(eLContext, new Object[0]);
                }
                catch (ELException eLException2) {
                    throwable = eLException2.getCause();
                    eLException = eLException2;
                }
            }
        }
        catch (ELException eLException3) {
            throwable = eLException3.getCause();
            eLException = eLException3;
        }
        if (null != eLException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "severe.event.exception_invoking_processaction", new Object[]{throwable == null ? ((Object)((Object)eLException)).getClass().getName() : throwable.getClass().getName(), this.methodExpressionOneArg.getExpressionString(), actionEvent.getComponent().getId()});
                StringWriter stringWriter = new StringWriter(1024);
                if (throwable == null) {
                    eLException.printStackTrace(new PrintWriter(stringWriter));
                } else {
                    throwable.printStackTrace(new PrintWriter(stringWriter));
                }
                LOGGER.severe(stringWriter.toString());
            }
            throw throwable == null ? new AbortProcessingException(eLException.getMessage(), eLException) : new AbortProcessingException(eLException.getMessage(), throwable);
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        return new Object[]{this.methodExpressionOneArg, this.methodExpressionZeroArg};
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        this.methodExpressionOneArg = (MethodExpression)((Object[])object)[0];
        this.methodExpressionZeroArg = (MethodExpression)((Object[])object)[1];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }
}

