/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.AttachedObjectListHolder;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.MessageFactory;
import javax.faces.component.MethodBindingValidator;
import javax.faces.component.MethodBindingValueChangeListener;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UpdateModelException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.MethodBinding;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    private static final String EMPTY_STRING_AS_NULL = "javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL";
    private static final String BEANS_VALIDATION_AVAILABLE = "javax.faces.private.BEANS_VALIDATION_AVAILABLE";
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    public static final String VALIDATE_EMPTY_FIELDS_PARAM_NAME = "javax.faces.VALIDATE_EMPTY_FIELDS";
    private static final Validator[] EMPTY_VALIDATOR = new Validator[0];
    private Boolean emptyStringIsNull;
    private Boolean validateEmptyFields;
    private Object submittedValue = null;
    AttachedObjectListHolder<Validator> validators;

    public UIInput() {
        this.setRendererType("javax.faces.Text");
    }

    public String getFamily() {
        return "javax.faces.Input";
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setSubmittedValue(Object object) {
        this.submittedValue = object;
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.setLocalValueSet(true);
    }

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public boolean isLocalValueSet() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.localValueSet), false);
    }

    public void setLocalValueSet(boolean bl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.localValueSet), bl);
    }

    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), false);
    }

    public String getRequiredMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.requiredMessage));
    }

    public void setRequiredMessage(String string) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.requiredMessage), string);
    }

    public String getConverterMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.converterMessage));
    }

    public void setConverterMessage(String string) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.converterMessage), string);
    }

    public String getValidatorMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.validatorMessage));
    }

    public void setValidatorMessage(String string) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.validatorMessage), string);
    }

    public boolean isValid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.valid), true);
    }

    public void setValid(boolean bl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.valid), bl);
    }

    public void setRequired(boolean bl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), bl);
    }

    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), false);
    }

    public void setImmediate(boolean bl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), bl);
    }

    public MethodBinding getValidator() {
        MethodBinding methodBinding = null;
        Validator[] validatorArray = this.getValidators();
        if (null != validatorArray) {
            for (int i = 0; i < validatorArray.length; ++i) {
                if (MethodBindingValidator.class != validatorArray[i].getClass()) continue;
                methodBinding = ((MethodBindingValidator)validatorArray[i]).getWrapped();
                break;
            }
        }
        return methodBinding;
    }

    public void setValidator(MethodBinding methodBinding) {
        Validator[] validatorArray = this.getValidators();
        if (null != validatorArray) {
            for (int i = 0; i < validatorArray.length; ++i) {
                if (null == methodBinding) {
                    if (MethodBindingValidator.class != validatorArray[i].getClass()) continue;
                    this.removeValidator(validatorArray[i]);
                    return;
                }
                if (methodBinding != validatorArray[i]) continue;
                this.removeValidator(validatorArray[i]);
                break;
            }
        }
        this.addValidator(new MethodBindingValidator(methodBinding));
    }

    public MethodBinding getValueChangeListener() {
        MethodBinding methodBinding = null;
        ValueChangeListener[] valueChangeListenerArray = this.getValueChangeListeners();
        if (null != valueChangeListenerArray) {
            for (int i = 0; i < valueChangeListenerArray.length; ++i) {
                if (MethodBindingValueChangeListener.class != valueChangeListenerArray[i].getClass()) continue;
                methodBinding = ((MethodBindingValueChangeListener)valueChangeListenerArray[i]).getWrapped();
                break;
            }
        }
        return methodBinding;
    }

    public void setValueChangeListener(MethodBinding methodBinding) {
        ValueChangeListener[] valueChangeListenerArray = this.getValueChangeListeners();
        if (null != valueChangeListenerArray) {
            for (int i = 0; i < valueChangeListenerArray.length; ++i) {
                if (null == methodBinding) {
                    if (MethodBindingValueChangeListener.class != valueChangeListenerArray[i].getClass()) continue;
                    this.removeFacesListener(valueChangeListenerArray[i]);
                    return;
                }
                if (methodBinding != valueChangeListenerArray[i]) continue;
                this.removeFacesListener(valueChangeListenerArray[i]);
                break;
            }
        }
        this.addValueChangeListener(new MethodBindingValueChangeListener(methodBinding));
    }

    public void markInitialState() {
        super.markInitialState();
        if (this.validators != null) {
            this.validators.markInitialState();
        }
    }

    public void clearInitialState() {
        if (this.initialStateMarked()) {
            super.clearInitialState();
            if (this.validators != null) {
                this.validators.clearInitialState();
            }
        }
    }

    public void processDecodes(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(facesContext);
        if (this.isImmediate()) {
            this.executeValidate(facesContext);
        }
    }

    public void processValidators(FacesContext facesContext) {
        Object object;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(facesContext, this);
        if (!this.isImmediate()) {
            object = facesContext.getApplication();
            ((Application)object).publishEvent(facesContext, PreValidateEvent.class, this);
            this.executeValidate(facesContext);
            ((Application)object).publishEvent(facesContext, PostValidateEvent.class, this);
        }
        object = this.getFacetsAndChildren();
        while (object.hasNext()) {
            ((UIComponent)object.next()).processValidators(facesContext);
        }
        this.popComponentFromEL(facesContext);
    }

    public void processUpdates(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(facesContext);
        try {
            this.updateModel(facesContext);
        }
        catch (RuntimeException runtimeException) {
            facesContext.renderResponse();
            throw runtimeException;
        }
        if (!this.isValid()) {
            facesContext.renderResponse();
        }
    }

    public void decode(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(facesContext);
    }

    public void updateModel(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression != null) {
            Object object;
            Throwable throwable = null;
            FacesMessage facesMessage = null;
            try {
                valueExpression.setValue(facesContext.getELContext(), this.getLocalValue());
                this.setValue(null);
                this.setLocalValueSet(false);
            }
            catch (ELException eLException) {
                throwable = eLException;
                object = eLException.getMessage();
                for (Throwable throwable2 = eLException.getCause(); null != throwable2 && throwable2.getClass().isAssignableFrom(ELException.class); throwable2 = throwable2.getCause()) {
                    object = throwable2.getMessage();
                }
                facesMessage = null == object ? MessageFactory.getMessage(facesContext, UPDATE_MESSAGE_ID, MessageFactory.getLabel(facesContext, this)) : new FacesMessage(FacesMessage.SEVERITY_ERROR, (String)object, (String)object);
                this.setValid(false);
            }
            catch (Exception exception) {
                throwable = exception;
                facesMessage = MessageFactory.getMessage(facesContext, UPDATE_MESSAGE_ID, MessageFactory.getLabel(facesContext, this));
                this.setValid(false);
            }
            if (throwable != null) {
                assert (facesMessage != null);
                UpdateModelException updateModelException = new UpdateModelException(facesMessage, throwable);
                object = new ExceptionQueuedEventContext(facesContext, updateModelException, this, PhaseId.UPDATE_MODEL_VALUES);
                facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, object);
            }
        }
    }

    public void validate(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        Object object = this.getSubmittedValue();
        if (object == null) {
            return;
        }
        if (this.considerEmptyStringNull(facesContext) && object instanceof String && ((String)object).length() == 0) {
            this.setSubmittedValue(null);
            object = null;
        }
        Object object2 = null;
        try {
            object2 = this.getConvertedValue(facesContext, object);
        }
        catch (ConverterException converterException) {
            this.addConversionErrorMessage(facesContext, converterException);
            this.setValid(false);
        }
        this.validateValue(facesContext, object2);
        if (this.isValid()) {
            Object object3 = this.getValue();
            this.setValue(object2);
            this.setSubmittedValue(null);
            if (this.compareValues(object3, object2)) {
                this.queueEvent(new ValueChangeEvent(this, object3, object2));
            }
        }
    }

    protected Object getConvertedValue(FacesContext facesContext, Object object) throws ConverterException {
        Converter converter;
        Renderer renderer = this.getRenderer(facesContext);
        Object object2 = renderer != null ? renderer.getConvertedValue(facesContext, this, object) : (object instanceof String ? ((converter = this.getConverterWithType(facesContext)) != null ? converter.getAsObject(facesContext, this, (String)object) : object) : object);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateValue(FacesContext facesContext, Object object) {
        Validator[] validatorArray;
        if (this.isValid() && this.isRequired() && UIInput.isEmpty(object)) {
            void var4_6;
            validatorArray = this.getRequiredMessage();
            if (null != validatorArray) {
                FacesMessage object2 = new FacesMessage(FacesMessage.SEVERITY_ERROR, (String)validatorArray, (String)validatorArray);
            } else {
                FacesMessage facesMessage = MessageFactory.getMessage(facesContext, REQUIRED_MESSAGE_ID, MessageFactory.getLabel(facesContext, this));
            }
            facesContext.addMessage(this.getClientId(facesContext), (FacesMessage)var4_6);
            this.setValid(false);
        }
        if (this.isValid() && (!UIInput.isEmpty(object) || this.validateEmptyFields(facesContext)) && this.validators != null) {
            for (Validator validator : validatorArray = this.validators.asArray(Validator.class)) {
                try {
                    validator.validate(facesContext, this, object);
                }
                catch (ValidatorException validatorException) {
                    FacesMessage facesMessage;
                    this.setValid(false);
                    String string = this.getValidatorMessage();
                    if (null != string) {
                        facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, string, string);
                        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                    } else {
                        Collection<FacesMessage> collection = validatorException.getFacesMessages();
                        if (null != collection) {
                            facesMessage = null;
                            String string2 = this.getClientId(facesContext);
                            for (FacesMessage facesMessage2 : collection) {
                                facesContext.addMessage(string2, facesMessage2);
                            }
                        } else {
                            facesMessage = validatorException.getFacesMessage();
                        }
                    }
                    if (facesMessage == null) continue;
                    facesContext.addMessage(this.getClientId(facesContext), facesMessage);
                }
            }
        }
    }

    protected boolean compareValues(Object object, Object object2) {
        boolean bl = true;
        if (object == null) {
            bl = object2 != null;
        } else if (object2 == null) {
            bl = true;
        } else {
            boolean bl2 = object.equals(object2);
            if (!bl2 && object instanceof Comparable && object2 instanceof Comparable) {
                try {
                    bl = 0 != ((Comparable)object).compareTo((Comparable)object2);
                }
                catch (ClassCastException classCastException) {
                    bl = true;
                }
            } else {
                bl = !bl2;
            }
        }
        return bl;
    }

    private void executeValidate(FacesContext facesContext) {
        try {
            this.validate(facesContext);
        }
        catch (RuntimeException runtimeException) {
            facesContext.renderResponse();
            throw runtimeException;
        }
        if (!this.isValid()) {
            facesContext.validationFailed();
            facesContext.renderResponse();
        }
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).length() < 1) {
            return true;
        }
        return object.getClass().isArray() ? 0 == Array.getLength(object) : object instanceof List && ((List)object).isEmpty();
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new AttachedObjectListHolder();
        }
        this.validators.add(validator);
    }

    public Validator[] getValidators() {
        return this.validators != null ? this.validators.asArray(Validator.class) : EMPTY_VALIDATOR;
    }

    public void removeValidator(Validator validator) {
        if (validator == null) {
            return;
        }
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public void addValueChangeListener(ValueChangeListener valueChangeListener) {
        this.addFacesListener(valueChangeListener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public void removeValueChangeListener(ValueChangeListener valueChangeListener) {
        this.removeFacesListener(valueChangeListener);
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = null;
        if (objectArray == null) {
            objectArray = new Object[]{super.saveState(facesContext), this.emptyStringIsNull, this.validateEmptyFields, this.validators != null ? this.validators.saveState(facesContext) : null};
        }
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        Object[] objectArray = (Object[])object;
        super.restoreState(facesContext, objectArray[0]);
        this.emptyStringIsNull = (Boolean)objectArray[1];
        this.validateEmptyFields = (Boolean)objectArray[2];
        if (objectArray[3] != null) {
            if (this.validators == null) {
                this.validators = new AttachedObjectListHolder();
            }
            this.validators.restoreState(facesContext, objectArray[3]);
        }
    }

    private Converter getConverterWithType(FacesContext facesContext) {
        Class clazz;
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        try {
            clazz = valueExpression.getType(facesContext.getELContext());
        }
        catch (ELException eLException) {
            throw new FacesException(eLException);
        }
        if (clazz == null || clazz == String.class || clazz == Object.class) {
            return null;
        }
        try {
            Application application = facesContext.getApplication();
            return application.createConverter(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addConversionErrorMessage(FacesContext facesContext, ConverterException converterException) {
        FacesMessage facesMessage;
        String string = this.getConverterMessage();
        if (null != string) {
            facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, string, string);
        } else {
            facesMessage = converterException.getFacesMessage();
            if (facesMessage == null && (facesMessage = MessageFactory.getMessage(facesContext, CONVERSION_MESSAGE_ID, new Object[0])).getDetail() == null) {
                facesMessage.setDetail(converterException.getMessage());
            }
        }
        facesContext.addMessage(this.getClientId(facesContext), facesMessage);
    }

    private boolean considerEmptyStringNull(FacesContext facesContext) {
        if (this.emptyStringIsNull == null) {
            String string = facesContext.getExternalContext().getInitParameter(EMPTY_STRING_AS_NULL);
            this.emptyStringIsNull = Boolean.valueOf(string);
        }
        return this.emptyStringIsNull;
    }

    private boolean validateEmptyFields(FacesContext facesContext) {
        if (this.validateEmptyFields == null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            String string = externalContext.getInitParameter(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            if (null == string) {
                string = (String)externalContext.getApplicationMap().get(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            }
            this.validateEmptyFields = string == null || "auto".equals(string) ? Boolean.valueOf(this.isBeansValidationAvailable(facesContext)) : Boolean.valueOf(string);
        }
        return this.validateEmptyFields;
    }

    private boolean isBeansValidationAvailable(FacesContext facesContext) {
        boolean bl = false;
        Map<String, Object> map = facesContext.getExternalContext().getApplicationMap();
        if (map.containsKey(BEANS_VALIDATION_AVAILABLE)) {
            bl = (Boolean)map.get(BEANS_VALIDATION_AVAILABLE);
        } else {
            try {
                new BeanValidator();
                bl = true;
                map.put(BEANS_VALIDATION_AVAILABLE, true);
            }
            catch (Throwable throwable) {
                map.put(BEANS_VALIDATION_AVAILABLE, Boolean.FALSE);
            }
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        localValueSet,
        required,
        requiredMessage,
        converterMessage,
        validatorMessage,
        valid,
        immediate;

    }
}

