/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttachedObjectListHolder<T>
implements PartialStateHolder {
    private boolean initialState;
    private List<T> attachedObjects = new ArrayList<T>(2);

    AttachedObjectListHolder() {
    }

    @Override
    public void markInitialState() {
        if (!this.attachedObjects.isEmpty()) {
            for (T t : this.attachedObjects) {
                if (!(t instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)t).markInitialState();
            }
        }
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        if (!this.attachedObjects.isEmpty()) {
            for (T t : this.attachedObjects) {
                if (!(t instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)t).clearInitialState();
            }
        }
        this.initialState = false;
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (this.attachedObjects == null) {
            return null;
        }
        if (this.initialState) {
            Object[] objectArray = new Object[this.attachedObjects.size()];
            boolean bl = false;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                T t = this.attachedObjects.get(i);
                if (!(t instanceof StateHolder)) continue;
                StateHolder stateHolder = (StateHolder)t;
                if (!stateHolder.isTransient()) {
                    objectArray[i] = stateHolder.saveState(facesContext);
                }
                if (objectArray[i] == null) continue;
                bl = true;
            }
            return bl ? objectArray : null;
        }
        Object[] objectArray = new Object[this.attachedObjects.size()];
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = UIComponentBase.saveAttachedState(facesContext, this.attachedObjects.get(i));
        }
        return objectArray;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length > 0 && objectArray[0] instanceof StateHolderSaver) {
            if (this.attachedObjects != null) {
                this.attachedObjects.clear();
            } else {
                this.attachedObjects = new ArrayList<T>(2);
            }
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = ((StateHolderSaver)objectArray[i]).restore(facesContext);
                if (object2 == null) continue;
                this.attachedObjects.add(object2);
            }
        } else {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                T t = this.attachedObjects.get(i);
                if (!(t instanceof StateHolder)) continue;
                ((StateHolder)t).restoreState(facesContext, objectArray[i]);
            }
        }
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void setTransient(boolean bl) {
    }

    void add(T t) {
        this.clearInitialState();
        this.attachedObjects.add(t);
    }

    void remove(T t) {
        this.clearInitialState();
        this.attachedObjects.remove(t);
    }

    T[] asArray(Class<T> clazz) {
        return new ArrayList<Object>(this.attachedObjects).toArray((Object[])Array.newInstance(clazz, this.attachedObjects.size()));
    }
}

