/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String EXCEPTION_HANDLER_FACTORY = "javax.faces.context.ExceptionHandlerFactory";
    public static final String EXTERNAL_CONTEXT_FACTORY = "javax.faces.context.ExternalContextFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String FACELET_CACHE_FACTORY = "javax.faces.view.facelets.FaceletCacheFactory";
    public static final String PARTIAL_VIEW_CONTEXT_FACTORY = "javax.faces.context.PartialViewContextFactory";
    public static final String VISIT_CONTEXT_FACTORY = "javax.faces.component.visit.VisitContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    public static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "javax.faces.view.ViewDeclarationLanguageFactory";
    public static final String TAG_HANDLER_DELEGATE_FACTORY = "javax.faces.view.facelets.TagHandlerDelegateFactory";
    private static final FactoryManagerCache FACTORIES_CACHE = new FactoryManagerCache();
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory"};
    private static Map<String, Class> factoryClasses;
    private static final Logger LOGGER;

    FactoryFinder() {
    }

    public static Object getFactory(String string) throws FacesException {
        FactoryFinder.validateFactoryName(string);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager factoryManager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        return factoryManager.getFactory(classLoader, string);
    }

    public static void setFactory(String string, String string2) {
        FactoryFinder.validateFactoryName(string);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager factoryManager = FactoryFinder.FACTORIES_CACHE.getApplicationFactoryManager(classLoader);
        factoryManager.addFactory(string, string2);
    }

    public static void releaseFactories() throws FacesException {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FACTORIES_CACHE.removeApplicationFactoryManager(classLoader);
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new FacesException("getContextClassLoader");
        }
        return classLoader;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String string, List list) throws FacesException {
        List<String> list2;
        String string2;
        int n;
        Object object = null;
        if (null != list && (1 < (n = list.size()) || 1 == n)) {
            string2 = (String)list.remove(n - 1);
            object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string2, null);
        }
        if ((list2 = FactoryFinder.getImplNameFromServices(classLoader, string)) != null) {
            for (String string3 : list2) {
                object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string3, object);
            }
        }
        if (null != list) {
            for (n = list.size() - 1; 0 <= n; --n) {
                string2 = (String)list.remove(n);
                object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string2, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getImplNameFromServices(ClassLoader classLoader, String string) {
        ArrayList<String> arrayList;
        block12: {
            arrayList = null;
            String string2 = "META-INF/services/" + string;
            BufferedReader bufferedReader = null;
            try {
                Enumeration<URL> enumeration = classLoader.getResources(string2);
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    InputStream inputStream = uRLConnection.getInputStream();
                    if (inputStream == null) continue;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>(3);
                        }
                        arrayList.add(bufferedReader.readLine());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    }
                    finally {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            bufferedReader = null;
                        }
                        if (inputStream == null) continue;
                        inputStream.close();
                        inputStream = null;
                    }
                }
            }
            catch (IOException iOException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
                }
            }
            catch (SecurityException securityException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, securityException.toString(), securityException);
            }
        }
        return arrayList;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String string, String string2, Object object) {
        Class<?> clazz;
        Class clazz2 = null;
        Object[] objectArray = new Object[1];
        Object var9_6 = null;
        if (null != object && null != (clazz2 = FactoryFinder.getFactoryClass(string))) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                Class[] classArray = new Class[]{clazz2};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                objectArray[0] = object;
                var9_6 = constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz2 = null;
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        if (null == object || null == clazz2) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                var9_6 = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        return var9_6;
    }

    private static Class getFactoryClass(String string) {
        return factoryClasses.get(string);
    }

    private static void validateFactoryName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Arrays.binarySearch(FACTORY_NAMES, string) < 0) {
            throw new IllegalArgumentException(string);
        }
    }

    private static void reInitializeFactoryManager() {
        FACTORIES_CACHE.resetSpecialInitializationCaseFlags();
    }

    static {
        Arrays.sort(FACTORY_NAMES);
        factoryClasses = new HashMap<String, Class>(FACTORY_NAMES.length);
        factoryClasses.put(APPLICATION_FACTORY, ApplicationFactory.class);
        factoryClasses.put(EXCEPTION_HANDLER_FACTORY, ExceptionHandlerFactory.class);
        factoryClasses.put(EXTERNAL_CONTEXT_FACTORY, ExternalContextFactory.class);
        factoryClasses.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
        factoryClasses.put(FACELET_CACHE_FACTORY, FaceletCacheFactory.class);
        factoryClasses.put(VISIT_CONTEXT_FACTORY, VisitContextFactory.class);
        factoryClasses.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
        factoryClasses.put(PARTIAL_VIEW_CONTEXT_FACTORY, PartialViewContextFactory.class);
        factoryClasses.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
        factoryClasses.put(VIEW_DECLARATION_LANGUAGE_FACTORY, ViewDeclarationLanguageFactory.class);
        factoryClasses.put(TAG_HANDLER_DELEGATE_FACTORY, TagHandlerDelegateFactory.class);
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    }

    private static final class FactoryManager {
        private final Map<String, Object> factories;
        private final Map<String, List<String>> savedFactoryNames;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

        public FactoryManager() {
            this.factories = new HashMap<String, Object>();
            this.savedFactoryNames = new HashMap<String, List<String>>();
            for (String string : FACTORY_NAMES) {
                this.factories.put(string, new ArrayList(4));
            }
        }

        public FactoryManager(FactoryManager factoryManager) {
            this.factories = new HashMap<String, Object>();
            this.savedFactoryNames = new HashMap<String, List<String>>();
            this.factories.putAll(factoryManager.savedFactoryNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFactory(String string, String string2) {
            Object object = this.factories.get(string);
            this.lock.writeLock().lock();
            try {
                if (object instanceof List) {
                    TypedCollections.dynamicallyCastList((List)object, String.class).add(0, string2);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getFactory(ClassLoader classLoader, String string) {
            Object object;
            this.lock.readLock().lock();
            try {
                object = this.factories.get(string);
                if (!(object instanceof List)) {
                    Object object2 = object;
                    return object2;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                Object object3;
                object = this.factories.get(string);
                if (!(object instanceof List)) {
                    Object object4 = object;
                    return object4;
                }
                this.savedFactoryNames.put(string, new ArrayList((List)object));
                Object object5 = FactoryFinder.getImplementationInstance(classLoader, string, (List)object);
                if (object5 == null) {
                    object3 = LOGGER.getResourceBundle();
                    String string2 = ((ResourceBundle)object3).getString("severe.no_factory");
                    string2 = MessageFormat.format(string2, string);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, string2);
                    }
                    if (null == (object5 = FACTORIES_CACHE.getFallbackFactory(classLoader, this, string))) {
                        string2 = ((ResourceBundle)object3).getString("severe.no_factory_backup_failed");
                        string2 = MessageFormat.format(string2, string);
                        throw new IllegalStateException(string2);
                    }
                }
                this.factories.put(string, object5);
                object3 = object5;
                return object3;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FactoryManagerCacheKey {
        private ClassLoader cl;
        private Long marker;
        private Object context;
        private static final String KEY = FactoryFinder.class.getName() + "." + FactoryManagerCacheKey.class.getSimpleName();

        public FactoryManagerCacheKey(FacesContext facesContext, ClassLoader classLoader, Map<FactoryManagerCacheKey, FactoryManager> map) {
            Object object;
            Map<String, Object> map2;
            Object object2;
            this.cl = classLoader;
            boolean bl = false;
            if (null == facesContext) {
                bl = true;
            } else {
                object2 = facesContext.getExternalContext();
                this.context = ((ExternalContext)object2).getContext();
                if (null == this.context) {
                    bl = true;
                } else {
                    map2 = ((ExternalContext)object2).getApplicationMap();
                    object = (Long)map2.get(KEY);
                    if (null == object) {
                        this.marker = new Long(System.currentTimeMillis());
                        map2.put(KEY, this.marker);
                    } else {
                        this.marker = object;
                    }
                }
            }
            if (bl) {
                object2 = map.keySet();
                map2 = null;
                object = object2.iterator();
                while (object.hasNext()) {
                    FactoryManagerCacheKey factoryManagerCacheKey = (FactoryManagerCacheKey)object.next();
                    if (!this.cl.equals(factoryManagerCacheKey.cl)) continue;
                    if (null != factoryManagerCacheKey && null != map2) {
                        LOGGER.log(Level.WARNING, "Multiple JSF Applications found on same ClassLoader.  Unable to safely determine which FactoryManager instance to use. Defaulting to first match.");
                        break;
                    }
                    map2 = factoryManagerCacheKey;
                }
                if (null != map2) {
                    this.marker = ((FactoryManagerCacheKey)((Object)map2)).marker;
                }
            }
        }

        public ClassLoader getClassLoader() {
            return this.cl;
        }

        public Object getContext() {
            return this.context;
        }

        private FactoryManagerCacheKey() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FactoryManagerCacheKey factoryManagerCacheKey = (FactoryManagerCacheKey)object;
            if (!(this.cl == factoryManagerCacheKey.cl || this.cl != null && this.cl.equals(factoryManagerCacheKey.cl))) {
                return false;
            }
            return this.marker == factoryManagerCacheKey.marker || this.marker != null && this.marker.equals(factoryManagerCacheKey.marker);
        }

        public int hashCode() {
            int n = 7;
            n = 97 * n + (this.cl != null ? this.cl.hashCode() : 0);
            n = 97 * n + (this.marker != null ? this.marker.hashCode() : 0);
            return n;
        }
    }

    private static final class FactoryManagerCache {
        private ConcurrentMap<FactoryManagerCacheKey, FactoryManager> applicationMap = new ConcurrentHashMap<FactoryManagerCacheKey, FactoryManager>();
        private AtomicBoolean logNullFacesContext = new AtomicBoolean(false);
        private AtomicBoolean logNonNullFacesContext = new AtomicBoolean(false);

        private FactoryManagerCache() {
        }

        private Object getFallbackFactory(ClassLoader classLoader, FactoryManager factoryManager, String string) {
            Object object = null;
            for (Map.Entry entry : this.applicationMap.entrySet()) {
                if (((FactoryManagerCacheKey)entry.getKey()).getClassLoader().equals(classLoader) && !((FactoryManager)entry.getValue()).equals(factoryManager) && null != (object = ((FactoryManager)entry.getValue()).getFactory(classLoader, string))) break;
            }
            return object;
        }

        private FactoryManager getApplicationFactoryManager(ClassLoader classLoader) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            boolean bl = this.detectSpecialInitializationCase(facesContext);
            FactoryManagerCacheKey factoryManagerCacheKey = new FactoryManagerCacheKey(facesContext, classLoader, this.applicationMap);
            Object object = (FactoryManager)this.applicationMap.get(factoryManagerCacheKey);
            FactoryManager factoryManager = null;
            if (object == null) {
                Object object2;
                boolean bl2 = false;
                if (bl) {
                    boolean bl3 = false;
                    boolean bl4 = true;
                    for (Map.Entry entry : this.applicationMap.entrySet()) {
                        object2 = (FactoryManagerCacheKey)entry.getKey();
                        if (!((FactoryManagerCacheKey)object2).getClassLoader().equals(classLoader)) continue;
                        bl4 = false;
                        if (null != factoryManagerCacheKey.getContext() && null != ((FactoryManagerCacheKey)object2).getContext() && !factoryManagerCacheKey.getContext().equals(((FactoryManagerCacheKey)object2).getContext())) {
                            bl3 = true;
                            factoryManager = (FactoryManager)entry.getValue();
                            break;
                        }
                        object = (FactoryManager)entry.getValue();
                        break;
                    }
                    bl2 = bl4 || null == object && bl3;
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    object2 = null != factoryManager ? new FactoryManager(factoryManager) : new FactoryManager();
                    object = this.applicationMap.putIfAbsent(factoryManagerCacheKey, (FactoryManager)object2);
                    object = null != object ? object : object2;
                }
            }
            return object;
        }

        private boolean detectSpecialInitializationCase(FacesContext facesContext) {
            boolean bl = false;
            if (null == facesContext) {
                this.logNullFacesContext.compareAndSet(false, true);
            } else {
                this.logNonNullFacesContext.compareAndSet(false, true);
            }
            bl = this.logNullFacesContext.get() && this.logNonNullFacesContext.get();
            return bl;
        }

        public void removeApplicationFactoryManager(ClassLoader classLoader) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            boolean bl = this.detectSpecialInitializationCase(facesContext);
            FactoryManagerCacheKey factoryManagerCacheKey = new FactoryManagerCacheKey(facesContext, classLoader, this.applicationMap);
            this.applicationMap.remove(factoryManagerCacheKey);
            if (bl) {
                this.logNullFacesContext.set(false);
                this.logNonNullFacesContext.set(false);
            }
        }

        public void resetSpecialInitializationCaseFlags() {
            this.logNullFacesContext.set(false);
            this.logNonNullFacesContext.set(false);
        }
    }
}

