/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureAfter(value={HttpMessageConvertersAutoConfiguration.class})
public class WebClientAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class})
    public static class RestTemplateConfiguration {
        private final ObjectProvider<HttpMessageConverters> messageConverters;
        private final ObjectProvider<List<RestTemplateCustomizer>> restTemplateCustomizers;

        public RestTemplateConfiguration(ObjectProvider<HttpMessageConverters> messageConverters, ObjectProvider<List<RestTemplateCustomizer>> restTemplateCustomizers) {
            this.messageConverters = messageConverters;
            this.restTemplateCustomizers = restTemplateCustomizers;
        }

        @Bean
        @ConditionalOnMissingBean
        public RestTemplateBuilder restTemplateBuilder() {
            List<RestTemplateCustomizer> customizers;
            RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
            HttpMessageConverters converters = this.messageConverters.getIfUnique();
            if (converters != null) {
                builder = builder.messageConverters(converters.getConverters());
            }
            if (!CollectionUtils.isEmpty(customizers = this.restTemplateCustomizers.getIfAvailable())) {
                customizers = new ArrayList<RestTemplateCustomizer>(customizers);
                AnnotationAwareOrderComparator.sort(customizers);
                builder = builder.customizers(customizers);
            }
            return builder;
        }
    }
}

