/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ansi;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.util.Assert;

public final class AnsiColors {
    private static final Map<AnsiColor, LabColor> ANSI_COLOR_MAP;

    private AnsiColors() {
    }

    public static AnsiColor getClosest(Color color) {
        return AnsiColors.getClosest(new LabColor(color));
    }

    private static AnsiColor getClosest(LabColor color) {
        AnsiColor result = null;
        double resultDistance = 3.4028234663852886E38;
        for (Map.Entry<AnsiColor, LabColor> entry : ANSI_COLOR_MAP.entrySet()) {
            double distance = color.getDistance(entry.getValue());
            if (result != null && !(distance < resultDistance)) continue;
            resultDistance = distance;
            result = entry.getKey();
        }
        return result;
    }

    static {
        LinkedHashMap<AnsiColor, LabColor> colorMap = new LinkedHashMap<AnsiColor, LabColor>();
        colorMap.put(AnsiColor.BLACK, new LabColor(0));
        colorMap.put(AnsiColor.RED, new LabColor(0xAA0000));
        colorMap.put(AnsiColor.GREEN, new LabColor(43520));
        colorMap.put(AnsiColor.YELLOW, new LabColor(0xAA5500));
        colorMap.put(AnsiColor.BLUE, new LabColor(170));
        colorMap.put(AnsiColor.MAGENTA, new LabColor(0xAA00AA));
        colorMap.put(AnsiColor.CYAN, new LabColor(43690));
        colorMap.put(AnsiColor.WHITE, new LabColor(0xAAAAAA));
        colorMap.put(AnsiColor.BRIGHT_BLACK, new LabColor(0x555555));
        colorMap.put(AnsiColor.BRIGHT_RED, new LabColor(0xFF5555));
        colorMap.put(AnsiColor.BRIGHT_GREEN, new LabColor(0x55FF00));
        colorMap.put(AnsiColor.BRIGHT_YELLOW, new LabColor(0xFFFF55));
        colorMap.put(AnsiColor.BRIGHT_BLUE, new LabColor(0x5555FF));
        colorMap.put(AnsiColor.BRIGHT_MAGENTA, new LabColor(0xFF55FF));
        colorMap.put(AnsiColor.BRIGHT_CYAN, new LabColor(0x55FFFF));
        colorMap.put(AnsiColor.BRIGHT_WHITE, new LabColor(0xFFFFFF));
        ANSI_COLOR_MAP = Collections.unmodifiableMap(colorMap);
    }

    private static final class LabColor {
        private static final ColorSpace XYZ_COLOR_SPACE = ColorSpace.getInstance(1001);
        private final double l;
        private final double a;
        private final double b;

        LabColor(Integer rgb) {
            this(rgb == null ? (Color)null : new Color(rgb));
        }

        LabColor(Color color) {
            Assert.notNull(color, "Color must not be null");
            float[] lab = this.fromXyz(color.getColorComponents(XYZ_COLOR_SPACE, null));
            this.l = lab[0];
            this.a = lab[1];
            this.b = lab[2];
        }

        private float[] fromXyz(float[] xyz) {
            return this.fromXyz(xyz[0], xyz[1], xyz[2]);
        }

        private float[] fromXyz(float x, float y, float z) {
            double l = (this.f(y) - 16.0) * 116.0;
            double a = (this.f(x) - this.f(y)) * 500.0;
            double b = (this.f(y) - this.f(z)) * 200.0;
            return new float[]{(float)l, (float)a, (float)b};
        }

        private double f(double t) {
            return t > 0.008856451679035631 ? Math.cbrt(t) : 0.3333333333333333 * Math.pow(4.833333333333333, 2.0) * t + 0.13793103448275862;
        }

        public double getDistance(LabColor other) {
            double c1 = Math.sqrt(this.a * this.a + this.b * this.b);
            double deltaC = c1 - Math.sqrt(other.a * other.a + other.b * other.b);
            double deltaA = this.a - other.a;
            double deltaB = this.b - other.b;
            double deltaH = Math.sqrt(Math.max(0.0, deltaA * deltaA + deltaB * deltaB - deltaC * deltaC));
            return Math.sqrt(Math.max(0.0, Math.pow((this.l - other.l) / 1.0, 2.0) + Math.pow(deltaC / (1.0 + 0.045 * c1), 2.0) + Math.pow(deltaH / (1.0 + 0.015 * c1), 2.0)));
        }
    }
}

