/*
 * Decompiled with CFR 0.152.
 */
package com.sudicode.githubextensions;

import com.google.gson.JsonParser;
import com.sudicode.githubextensions.global.Environment;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

@SpringBootApplication
public class WebhookApplication {
    public static void main(String[] args) {
        Assert.notNull(Environment.API_KEY, "Please set API_KEY in your environment variables");
        Assert.notNull(Environment.SECRET_TOKEN, "Please set SECRET_TOKEN in your environment variables");
        SpringApplication.run(WebhookApplication.class, args);
    }

    @Bean
    public GitHubClient getGitHubClient() {
        GitHubClient gitHubClient = new GitHubClient();
        gitHubClient.setOAuth2Token(Environment.API_KEY);
        return gitHubClient;
    }

    @Bean
    public JsonParser getJsonParser() {
        return new JsonParser();
    }
}

