/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.TreeDef;
import com.diffplug.common.base.TreeNode;
import com.diffplug.common.base.TreeQuery;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;

public final class TreeComparison<E, A> {
    private final TreeDef<E> expectedDef;
    private final E expectedRoot;
    private final TreeDef<A> actualDef;
    private final A actualRoot;
    private Function<? super E, String> expectedToString = Object::toString;
    private Function<? super A, String> actualToString = Object::toString;

    private TreeComparison(TreeDef<E> expectedDef, E expectedRoot, TreeDef<A> actualDef, A actualRoot) {
        this.expectedDef = expectedDef;
        this.expectedRoot = expectedRoot;
        this.actualDef = actualDef;
        this.actualRoot = actualRoot;
    }

    public boolean isEqualMappedBy(Function<? super E, ?> expectedMapper, Function<? super A, ?> actualMapper) {
        return this.isEqualBasedOn((expected, actual) -> Objects.equals(expectedMapper.apply((Object)expected), actualMapper.apply((Object)actual)));
    }

    public boolean isEqualBasedOn(BiPredicate<? super E, ? super A> compareFunc) {
        return TreeComparison.equals(this.expectedDef, this.expectedRoot, this.actualDef, this.actualRoot, compareFunc);
    }

    private static <E, A> boolean equals(TreeDef<E> expectedDef, E expectedRoot, TreeDef<A> actualDef, A actualRoot, BiPredicate<? super E, ? super A> compareFunc) {
        if (!compareFunc.test(expectedRoot, actualRoot)) {
            return false;
        }
        List<E> expectedChildren = expectedDef.childrenOf(expectedRoot);
        List<A> actualChildren = actualDef.childrenOf(actualRoot);
        if (expectedChildren.size() != actualChildren.size()) {
            return false;
        }
        for (int i = 0; i < expectedChildren.size(); ++i) {
            A actualChild;
            E expectedChild = expectedChildren.get(i);
            if (TreeComparison.equals(expectedDef, expectedChild, actualDef, actualChild = actualChildren.get(i), compareFunc)) continue;
            return false;
        }
        return true;
    }

    public void assertEqualMappedBy(Function<? super E, ?> expectedMapper, Function<? super A, ?> actualMapper) {
        if (!this.isEqualMappedBy(expectedMapper, actualMapper)) {
            this.throwAssertionError();
        }
    }

    public void assertEqualBasedOn(BiPredicate<E, A> compareFunc) {
        if (!this.isEqualBasedOn(compareFunc)) {
            this.throwAssertionError();
        }
    }

    public TreeComparison<E, A> decorateErrorsWith(Function<? super E, String> expectedToString, Function<? super A, String> actualToString) {
        this.expectedToString = expectedToString;
        this.actualToString = actualToString;
        return this;
    }

    private void throwAssertionError() {
        throw this.createAssertionError();
    }

    private AssertionError createAssertionError() {
        String expected = TreeQuery.toString(this.expectedDef, this.expectedRoot, this.expectedToString);
        String actual = TreeQuery.toString(this.actualDef, this.actualRoot, this.actualToString);
        for (String exceptionType : Arrays.asList("org.junit.ComparisonFailure", "junit.framework.ComparisonFailure")) {
            try {
                return this.createComparisonFailure(exceptionType, expected, actual);
            }
            catch (Exception e) {
            }
        }
        return new AssertionError((Object)("Expected:\n" + expected + "\n\nActual:\n" + actual));
    }

    private AssertionError createComparisonFailure(String className, String expected, String actual) throws Exception {
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(String.class, String.class, String.class);
        return (AssertionError)constructor.newInstance("", expected, actual);
    }

    public <T> SameType<T> mapToSame(Function<? super E, ? extends T> mapExpected, Function<? super A, ? extends T> mapActual) {
        return new SameTypeImp<E, A, T>(this, mapExpected, mapActual);
    }

    public static <E, A> TreeComparison<E, A> of(TreeDef<E> expectedDef, E expectedRoot, TreeDef<A> actualDef, A actualRoot) {
        return new TreeComparison<E, A>(expectedDef, expectedRoot, actualDef, actualRoot);
    }

    public static <T> SameType<T> of(TreeDef<T> treeDef, T expected, T actual) {
        return TreeComparison.of(treeDef, expected, treeDef, actual).mapToSame(Function.identity(), Function.identity());
    }

    public static <T> SameType<T> of(TreeNode<T> expected, TreeDef<T> treeDef, T actual) {
        return TreeComparison.of(expected, treeDef, actual, Function.identity());
    }

    public static <T, U> SameType<T> of(TreeNode<T> expected, TreeDef<U> treeDef, U actual, Function<? super U, ? extends T> mapper) {
        return TreeComparison.of(TreeNode.treeDef(), expected, treeDef, actual).mapToSame(TreeNode::getContent, mapper);
    }

    public static <T> SameType<T> of(TreeNode<T> expected, TreeNode<T> actual) {
        return TreeComparison.of(TreeNode.treeDef(), expected, TreeNode.treeDef(), actual).mapToSame(TreeNode::getContent, TreeNode::getContent);
    }

    private static class SameTypeImp<E, A, T>
    implements SameType<T> {
        private final TreeComparison<E, A> comparison;
        private final Function<? super E, ? extends T> mapExpected;
        private final Function<? super A, ? extends T> mapActual;

        public SameTypeImp(TreeComparison<E, A> comparison, Function<? super E, ? extends T> mapExpected, Function<? super A, ? extends T> mapActual) {
            this.comparison = comparison;
            this.mapExpected = mapExpected;
            this.mapActual = mapActual;
            comparison.decorateErrorsWith(mapExpected.andThen(Objects::toString), mapActual.andThen(Objects::toString));
        }

        @Override
        public boolean isEqual() {
            return this.comparison.isEqualMappedBy(this.mapExpected, this.mapActual);
        }

        @Override
        public void assertEqual() {
            this.comparison.assertEqualMappedBy(this.mapExpected, this.mapActual);
        }

        @Override
        public SameType<T> decorateErrorsWith(Function<? super T, String> toString) {
            this.comparison.decorateErrorsWith(toString.compose(this.mapExpected), toString.compose(this.mapActual));
            return this;
        }

        @Override
        public <R> SameType<R> map(Function<? super T, ? extends R> mapper) {
            return new SameTypeImp<E, A, R>(this.comparison, this.mapExpected.andThen(mapper), this.mapActual.andThen(mapper));
        }
    }

    public static interface SameType<T> {
        public boolean isEqual();

        public void assertEqual();

        public SameType<T> decorateErrorsWith(Function<? super T, String> var1);

        public <R> SameType<R> map(Function<? super T, ? extends R> var1);
    }
}

