/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return t -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return t -> false;
    }

    public static <T> Predicate<T> isNull() {
        return Objects::isNull;
    }

    public static <T> Predicate<T> notNull() {
        return Objects::nonNull;
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(Predicates.defensiveCopy(components));
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return new AndPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        return new AndPredicate(Predicates.asList(Objects.requireNonNull(first), Objects.requireNonNull(second)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(Predicates.defensiveCopy(components));
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return new OrPredicate(Predicates.defensiveCopy(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return new OrPredicate(Predicates.asList(Objects.requireNonNull(first), Objects.requireNonNull(second)));
    }

    public static <T> Predicate<T> equalTo(@Nullable T target) {
        return target == null ? Predicates.isNull() : t -> Objects.equals(t, target);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return t -> clazz.isInstance(t);
    }

    public static Predicate<Class<?>> assignableFrom(Class<?> clazz) {
        return t -> clazz.isAssignableFrom((Class<?>)t);
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        return t -> {
            try {
                return target.contains(t);
            }
            catch (ClassCastException | NullPointerException e) {
                return false;
            }
        };
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return t -> predicate.test(function.apply(t));
    }

    public static Predicate<CharSequence> containsPattern(String pattern) {
        return Predicates.contains(Pattern.compile(pattern));
    }

    public static Predicate<CharSequence> contains(Pattern pattern) {
        return t -> pattern.matcher((CharSequence)t).find();
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> first, Predicate<? super T> second) {
        return Arrays.asList(first, second);
    }

    @SafeVarargs
    private static <T> List<T> defensiveCopy(T ... array) {
        return Predicates.defensiveCopy(Arrays.asList(array));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element));
        }
        return list;
    }

    private static class OrPredicate<T>
    implements Predicate<T> {
        private final List<? extends Predicate<? super T>> components;

        private OrPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean test(@Nullable T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!this.components.get(i).test(t)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T> {
        private final List<? extends Predicate<? super T>> components;

        private AndPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean test(@Nullable T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (this.components.get(i).test(t)) continue;
                return false;
            }
            return true;
        }
    }
}

