package com.sudicode.githubextensions.global;

/**
 * Environment variables, which must be set on the server.
 */
public class Environment {

    private Environment() {
        // illegal
    }

    /**
     * GitHub secret token.
     *
     * @see <a href="https://developer.github.com/webhooks/securing/">Securing your webhooks</a>
     */
    public static final String SECRET_TOKEN = System.getenv("SECRET_TOKEN");

    /**
     * GitHub API key.
     *
     * @see <a href="https://github.com/blog/1509-personal-api-tokens">Personal API tokens</a>
     */
    public static final String API_KEY = System.getenv("API_KEY");

}
