package com.sudicode.githubextensions;

import com.google.gson.JsonParser;
import com.sudicode.githubextensions.global.Environment;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

/**
 * Web application.
 */
@SpringBootApplication
public class WebhookApplication {

    /**
     * Start the web application.
     *
     * @param args the application arguments
     */
    public static void main(String[] args) {
        // Ensure that environment variables are set
        Assert.notNull(Environment.API_KEY, "Please set API_KEY in your environment variables");
        Assert.notNull(Environment.SECRET_TOKEN, "Please set SECRET_TOKEN in your environment variables");

        // Run the application
        SpringApplication.run(WebhookApplication.class, args);
    }

    /**
     * Get a {@link GitHubClient}.
     *
     * @return A {@link GitHubClient}
     */
    @Bean
    public GitHubClient getGitHubClient() {
        GitHubClient gitHubClient = new GitHubClient();
        gitHubClient.setOAuth2Token(Environment.API_KEY);
        return gitHubClient;
    }

    /**
     * Get a {@link JsonParser}.
     *
     * @return A {@link JsonParser}
     */
    @Bean
    public JsonParser getJsonParser() {
        return new JsonParser();
    }

}
