package com.sudicode.githubextensions;

import com.diffplug.common.base.Throwing;
import com.google.gson.JsonObject;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * API calls.
 */
public class GithubWebhook {

    private static final Logger LOG = LoggerFactory.getLogger(GithubWebhook.class);
    private static Throwing.BiConsumer<JsonObject, GitHubClient> onHookEvent;

    static {
        // Echo payload back by default.
        setOnHookEvent((payload, gitHubClient) -> LOG.info("Received payload: {}", payload));
    }

    private GithubWebhook() {
        // illegal
    }

    /**
     * Set what happens when a webhook request is delivered.
     *
     * @param onHookEvent {@link Throwing.BiConsumer} containing {@link JsonObject} (the request payload) and {@link GitHubClient} (authentication for the API).
     */
    public static void setOnHookEvent(Throwing.BiConsumer<JsonObject, GitHubClient> onHookEvent) {
        GithubWebhook.onHookEvent = onHookEvent;
    }

    /**
     * Get what happens when a webhook request is delivered.
     *
     * @return {@link Throwing.BiConsumer} containing {@link JsonObject} (the request payload) and {@link GitHubClient} (authentication for the API).
     */
    public static Throwing.BiConsumer<JsonObject, GitHubClient> getOnHookEvent() {
        return onHookEvent;
    }

    /**
     * Start the webhook.
     */
    public static void startServer() {
        WebhookApplication.main(new String[0]);
    }

}
