/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.mermaid;

import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.mermaid.MermaidDiagram;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.LineStyle;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import java.util.LinkedHashSet;

public class MermaidDiagramExporter
extends AbstractDiagramExporter {
    public static final String MERMAID_TITLE_PROPERTY = "mermaid.title";
    public static final String MERMAID_SEQUENCE_DIAGRAM_PROPERTY = "mermaid.sequenceDiagram";
    public static final String MERMAID_ICONS_PROPERTY = "mermaid.icons";
    private int groupId = 0;

    @Override
    protected void writeHeader(ModelView view, IndentingWriter writer) {
        this.groupId = 0;
        String direction = "TB";
        if (view.getAutomaticLayout() != null) {
            switch (view.getAutomaticLayout().getRankDirection()) {
                case TopBottom: {
                    direction = "TB";
                    break;
                }
                case BottomTop: {
                    direction = "BT";
                    break;
                }
                case LeftRight: {
                    direction = "LR";
                    break;
                }
                case RightLeft: {
                    direction = "RL";
                }
            }
        }
        writer.writeLine("graph " + direction);
        writer.indent();
        writer.writeLine("linkStyle default fill:#ffffff");
        writer.writeLine();
        String viewTitle = " ";
        if (this.includeTitle(view) && StringUtils.isNullOrEmpty((String)(viewTitle = view.getTitle()))) {
            viewTitle = view.getName();
        }
        writer.writeLine("subgraph diagram [\"" + viewTitle + "\"]");
        writer.indent();
        writer.writeLine("style diagram fill:#ffffff,stroke:#ffffff");
        writer.writeLine();
    }

    @Override
    protected void writeFooter(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.outdent();
    }

    @Override
    protected void startEnterpriseBoundary(ModelView view, String enterpriseName, IndentingWriter writer) {
        writer.writeLine("subgraph enterprise [\"" + enterpriseName + "\"]");
        writer.indent();
        writer.writeLine("style enterprise fill:#ffffff,stroke:#444444,color:#444444");
        writer.writeLine();
    }

    @Override
    protected void endEnterpriseBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startGroupBoundary(ModelView view, String group, IndentingWriter writer) {
        ++this.groupId;
        String groupName = group;
        String groupSeparator = (String)view.getModel().getProperties().get("structurizr.groupSeparator");
        if (!StringUtils.isNullOrEmpty((String)groupSeparator)) {
            groupName = group.substring(group.lastIndexOf(groupSeparator) + groupSeparator.length());
        }
        String color = "#cccccc";
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group:" + group);
        if (elementStyle == null || StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
            elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle("Group");
        }
        if (elementStyle != null && !StringUtils.isNullOrEmpty((String)elementStyle.getColor())) {
            color = elementStyle.getColor();
        }
        writer.writeLine(String.format("subgraph group%s [\"" + groupName + "\"]", this.groupId));
        writer.indent();
        writer.writeLine(String.format("style group%s fill:#ffffff,stroke:%s,color:%s,stroke-dasharray:5", this.groupId, color, color));
        writer.writeLine();
    }

    @Override
    protected void endGroupBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startSoftwareSystemBoundary(ModelView view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle((Element)softwareSystem);
        String color = elementStyle.getStroke();
        writer.writeLine(String.format("subgraph %s [\"%s\"]", softwareSystem.getId(), softwareSystem.getName()));
        writer.indent();
        writer.writeLine(String.format("style %s fill:#ffffff,stroke:%s,color:%s", softwareSystem.getId(), color, color));
        writer.writeLine();
    }

    @Override
    protected void endSoftwareSystemBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startContainerBoundary(ModelView view, Container container, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle((Element)container);
        String color = elementStyle.getStroke();
        writer.writeLine(String.format("subgraph %s [\"%s\"]", container.getId(), container.getName()));
        writer.indent();
        writer.writeLine(String.format("style %s fill:#ffffff,stroke:%s,color:%s", container.getId(), color, color));
        writer.writeLine();
    }

    @Override
    protected void endContainerBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle((Element)deploymentNode);
        writer.writeLine(String.format("subgraph %s [\"%s\"]", deploymentNode.getId(), deploymentNode.getName()));
        writer.indent();
        writer.writeLine(String.format("style %s fill:#ffffff,stroke:%s,color:%s", deploymentNode.getId(), elementStyle.getStroke(), elementStyle.getColor()));
        writer.writeLine();
    }

    @Override
    protected void endDeploymentNodeBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("end");
        writer.writeLine();
    }

    @Override
    public Diagram export(DynamicView view) {
        if (this.renderAsSequenceDiagram((ModelView)view)) {
            IndentingWriter writer = new IndentingWriter();
            writer.writeLine("sequenceDiagram");
            writer.writeLine();
            writer.indent();
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                elements.add(relationshipView.getRelationship().getSource());
                elements.add(relationshipView.getRelationship().getDestination());
            }
            for (Element element : elements) {
                Object type;
                ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
                String shape = "participant";
                if (elementStyle.getShape() == Shape.Person) {
                    shape = "actor";
                }
                type = StringUtils.isNullOrEmpty((String)(type = this.typeOf((ModelView)view, element, true))) || false == elementStyle.getMetadata() ? "" : "<br />" + (String)type;
                writer.writeLine(String.format("%s %s as %s%s", shape, element.getId(), element.getName(), type));
            }
            writer.writeLine();
            for (RelationshipView relationshipView : view.getRelationships()) {
                Relationship relationship = relationshipView.getRelationship();
                RelationshipStyle style = view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship);
                String description = relationshipView.getDescription();
                if (StringUtils.isNullOrEmpty((String)description)) {
                    description = relationship.getDescription();
                }
                String sourceId = relationship.getSourceId();
                String destinationId = relationship.getDestinationId();
                if (relationshipView.isResponse().booleanValue()) {
                    sourceId = relationship.getDestinationId();
                    destinationId = relationship.getSourceId();
                }
                String technology = !StringUtils.isNullOrEmpty((String)relationship.getTechnology()) ? "<br />[" + relationship.getTechnology() + "]" : "";
                String arrow = relationshipView.isResponse() == false ? "->>" : "-->>";
                writer.writeLine(String.format("%s%s%s: %s%s", sourceId, arrow, destinationId, description, technology));
            }
            return this.createDiagram((ModelView)view, writer.toString());
        }
        return super.export(view);
    }

    @Override
    protected void writeElement(ModelView view, Element element, IndentingWriter writer) {
        ElementStyle elementStyle = view.getViewSet().getConfiguration().getStyles().findElementStyle(element);
        String name = element.getName();
        String description = element.getDescription();
        String type = this.typeOf(view, element, true);
        Object icon = "";
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
            name = elementInstance.getElement().getName();
            description = elementInstance.getElement().getDescription();
            type = this.typeOf(view, (Element)elementInstance.getElement(), true);
        }
        String nodeOpeningSymbol = "[";
        String nodeClosingSymbol = "]";
        if (elementStyle.getShape() == Shape.RoundedBox) {
            nodeOpeningSymbol = "(";
            nodeClosingSymbol = ")";
        } else if (elementStyle.getShape() == Shape.Cylinder) {
            nodeOpeningSymbol = "[(";
            nodeClosingSymbol = ")]";
        }
        description = StringUtils.isNullOrEmpty((String)description) || false == elementStyle.getDescription() ? "" : String.format("<div style='font-size: 80%%; margin-top:10px'>%s</div>", this.lines(description));
        type = false == elementStyle.getMetadata() ? "" : String.format("<div style='font-size: 70%%; margin-top: 0px'>%s</div>", type);
        if ("true".equals(this.getViewOrViewSetProperty(view, MERMAID_ICONS_PROPERTY, "false")) && this.elementStyleHasSupportedIcon(elementStyle)) {
            icon = "<div><img src='" + elementStyle.getIcon() + "' style='max-height: 50px; margin: auto; margin-top:10px'/></div>";
        }
        writer.writeLine(String.format("%s%s\"<div style='font-weight: bold'>%s</div>%s%s%s\"%s", element.getId(), nodeOpeningSymbol, name, type, description, icon, nodeClosingSymbol));
        if (!StringUtils.isNullOrEmpty((String)element.getUrl())) {
            writer.writeLine(String.format("click %s %s \"%s\"", element.getId(), element.getUrl(), element.getUrl()));
        }
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElement e = ((StaticStructureElementInstance)element).getElement();
            writer.writeLine(String.format("style %s fill:%s,stroke:%s,color:%s", element.getId(), elementStyle.getBackground(), elementStyle.getStroke(), elementStyle.getColor()));
        } else {
            writer.writeLine(String.format("style %s fill:%s,stroke:%s,color:%s", element.getId(), elementStyle.getBackground(), elementStyle.getStroke(), elementStyle.getColor()));
        }
    }

    @Override
    protected void writeRelationship(ModelView view, RelationshipView relationshipView, IndentingWriter writer) {
        Relationship relationship = relationshipView.getRelationship();
        RelationshipStyle style = view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship);
        Element source = relationship.getSource();
        Element destination = relationship.getDestination();
        if (source instanceof DeploymentNode || destination instanceof DeploymentNode) {
            return;
        }
        if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
            source = relationship.getDestination();
            destination = relationship.getSource();
        }
        boolean solid = style.getStyle() == LineStyle.Solid || false == style.getDashed();
        Object description = relationshipView.getDescription();
        if (StringUtils.isNullOrEmpty((String)description)) {
            description = relationshipView.getRelationship().getDescription();
        }
        if (!StringUtils.isNullOrEmpty((String)relationshipView.getOrder())) {
            description = relationshipView.getOrder() + ". " + (String)description;
        }
        writer.writeLine(String.format("%s-%s \"<div>%s</div><div style='font-size: 70%%'>%s</div>\" %s->%s", source.getId(), solid ? "-" : ".", this.lines((String)description), !StringUtils.isNullOrEmpty((String)relationship.getTechnology()) ? "[" + relationship.getTechnology() + "]" : "", solid ? "-" : ".", destination.getId()));
    }

    private String lines(String text) {
        StringBuilder buf = new StringBuilder();
        if (text != null) {
            String[] words = text.trim().split("\\s+");
            StringBuilder line = new StringBuilder();
            for (String word : words) {
                if (line.length() == 0) {
                    line.append(word);
                    continue;
                }
                if (line.length() + word.length() + 1 < 30) {
                    line.append(' ').append(word);
                    continue;
                }
                buf.append(line.toString());
                buf.append("<br />");
                line.setLength(0);
                line.append(word);
            }
            if (line.length() > 0) {
                buf.append(line.toString());
            }
        }
        return buf.toString();
    }

    @Override
    protected Diagram createDiagram(ModelView view, String definition) {
        return new MermaidDiagram(view, definition);
    }

    protected boolean includeTitle(ModelView view) {
        return "true".equals(this.getViewOrViewSetProperty(view, MERMAID_TITLE_PROPERTY, "true"));
    }

    protected boolean renderAsSequenceDiagram(ModelView view) {
        return "true".equalsIgnoreCase(this.getViewOrViewSetProperty(view, MERMAID_SEQUENCE_DIAGRAM_PROPERTY, "false"));
    }

    private boolean elementStyleHasSupportedIcon(ElementStyle elementStyle) {
        return !StringUtils.isNullOrEmpty((String)elementStyle.getIcon()) && elementStyle.getIcon().startsWith("http");
    }
}

